/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.content.ContentCleaner;
import com.atlassian.confluence.core.BodyType;
import com.atlassian.confluence.core.ContentEntityObject;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import java.io.Serializable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Target;
import org.hibernate.annotations.Type;

@Entity
@Table(name="BODYCONTENT", indexes={@Index(name="body_content_idx", columnList="CONTENTID")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Access(value=AccessType.PROPERTY)
public class BodyContent
implements Cloneable,
Serializable {
    private long id;
    private String body;
    private ContentEntityObject content;
    private BodyType bodyType;
    private boolean bodyCleaned = false;

    public BodyContent() {
    }

    public BodyContent(BodyContent orig) {
        this.shallowCopy(orig);
    }

    public BodyContent(ContentEntityObject content, String body, BodyType bodyType) {
        this.content = content;
        this.body = body;
        this.bodyType = bodyType;
        this.bodyCleaned = false;
    }

    public void shallowCopy(BodyContent orig) {
        this.content = orig.getContent();
        this.body = orig.getBody();
        this.bodyType = orig.getBodyType();
        this.bodyCleaned = orig.isBodyCleaned();
    }

    @Column(name="BODY", length=0x7FFFFFFF)
    @Type(type="com.atlassian.confluence.core.persistence.hibernate.CustomClobType")
    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        if (body != null && body.equals(this.body)) {
            return;
        }
        if (body == null) {
            body = "";
        }
        this.body = body;
        this.bodyCleaned = false;
    }

    @Column(name="BODYTYPEID")
    @Type(type="com.atlassian.confluence.core.BodyTypeUserType")
    public BodyType getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(BodyType bodyType) {
        if (bodyType != null && bodyType.equals(this.bodyType)) {
            return;
        }
        this.bodyType = bodyType;
        this.bodyCleaned = false;
    }

    @Id
    @Column(name="BODYCONTENTID")
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="CONTENTID")
    @Target(value=ContentEntityObject.class)
    public ContentEntityObject getContent() {
        return this.content;
    }

    public void setContent(ContentEntityObject content) {
        this.content = content;
    }

    @Transient
    public boolean isBodyCleaned() {
        return this.bodyCleaned;
    }

    public String cleanBody(ContentCleaner cleaner) {
        this.body = cleaner.clean(this.body);
        this.bodyCleaned = true;
        return this.body;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BodyContent that = (BodyContent)o;
        if (this.id != that.id) {
            return false;
        }
        if (!this.body.equals(that.body)) {
            return false;
        }
        if (this.content.getId() != that.content.getId()) {
            return false;
        }
        if (this.bodyCleaned != that.bodyCleaned) {
            return false;
        }
        if (this.bodyType == null) {
            return that.bodyType == null;
        }
        return this.bodyType.equals(that.bodyType);
    }

    public int hashCode() {
        int result = Long.hashCode(this.id);
        long contentId = this.content == null ? 0L : this.content.getId();
        result = 29 * result + Long.hashCode(contentId);
        result = 29 * result + (this.bodyCleaned ? 1 : 0);
        result = 29 * result + this.body.hashCode();
        if (this.bodyType != null) {
            result = 29 * this.bodyType.hashCode();
        }
        return result;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new RuntimeException(ex);
        }
    }
}

