/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.confluence.api.service.accessmode.AccessModeService;
import com.atlassian.confluence.cache.ThreadLocalCacheAccessor;
import com.atlassian.confluence.content.ui.ContentUiSupport;
import com.atlassian.confluence.core.AbstractI18nActionSupport;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.DateFormatter;
import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.event.events.security.NoConfluencePermissionEvent;
import com.atlassian.confluence.impl.setup.BootstrapStatusProviderImpl;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.languages.LanguageManager;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.pages.AbstractPage;
import com.atlassian.confluence.pages.actions.PageAware;
import com.atlassian.confluence.plugin.descriptor.web.DefaultWebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.WebInterface;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.SpacePermissionManager;
import com.atlassian.confluence.security.access.ConfluenceAccessManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.setup.BootstrapStatusProvider;
import com.atlassian.confluence.setup.settings.GlobalSettingsManager;
import com.atlassian.confluence.setup.settings.Settings;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.spaces.Spaced;
import com.atlassian.confluence.status.service.SystemInformationService;
import com.atlassian.confluence.struts.StrutsHelper;
import com.atlassian.confluence.struts.soy.ActionViewData;
import com.atlassian.confluence.themes.GlobalHelper;
import com.atlassian.confluence.themes.ThemeHelper;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.user.UserInterfaceState;
import com.atlassian.confluence.user.UsernameCacheKey;
import com.atlassian.confluence.user.actions.UserAware;
import com.atlassian.confluence.user.history.UserHistory;
import com.atlassian.confluence.user.persistence.dao.compatibility.FindUserHelper;
import com.atlassian.confluence.util.PlainTextToHtmlConverter;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import com.atlassian.confluence.validation.MessageHolder;
import com.atlassian.confluence.validation.MessageHolderAware;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.sal.api.timezone.TimeZoneManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.interceptor.parameter.StrutsParameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;

public class ConfluenceActionSupport
extends AbstractI18nActionSupport
implements WebInterface,
MessageHolderAware {
    private static final Logger LOG = LoggerFactory.getLogger(ConfluenceActionSupport.class);
    private static final ThreadLocalCacheAccessor<UsernameCacheKey, Optional<ConfluenceUser>> userCacheAccessor = ThreadLocalCacheAccessor.newInstance();
    public static final String CANCEL = "cancel";
    public static final String PREVIEW = "preview";
    public static final String LICENSE_EXPIRED = "licenseexpired";
    public static final String LICENSE_USERS_EXCEEDED = "licenseusersexceeded";
    private String cancel;
    private Date previousLoginDate;
    protected MessageHolder messageHolder;
    protected HttpServletRequest request;
    protected HttpServletResponse response;
    private UserInterfaceState userInterfaceState;
    private GlobalHelper globalHelper;
    private DateFormatter dateFormatter;
    private BootstrapStatusProvider bootstrapStatusProvider;
    protected UserAccessor userAccessor;
    protected EventPublisher eventPublisher;
    protected SpacePermissionManager spacePermissionManager;
    protected PermissionManager permissionManager;
    protected ConfluenceAccessManager confluenceAccessManager;
    protected GlobalSettingsManager globalSettingsManager;
    protected LabelManager labelManager;
    protected LanguageManager languageManager;
    protected ContentUiSupport contentUiSupport;
    protected LocaleManager localeManager;
    private I18NBean i18NBean;
    protected I18NBeanFactory i18NBeanFactory;
    protected DynamicWebInterfaceManager webInterfaceManager;
    protected FormatSettingsManager formatSettingsManager;
    protected SystemInformationService systemInformationService;
    protected LoginManager loginManager;
    private TimeZoneManager timeZoneManager;
    protected AccessModeService accessModeService;
    protected PluginAccessor pluginAccessor;
    protected StrutsHelper strutsHelper;

    @StrutsParameter
    public void setCancel(String cancel) {
        this.cancel = cancel;
    }

    boolean isCanceled() {
        return StringUtils.isNotBlank((CharSequence)this.cancel);
    }

    public String doDefault() throws Exception {
        return "input";
    }

    public String getActionName() {
        return this.getText(this.getClass().getName() + ".action.name");
    }

    public boolean isPermitted() {
        if (!this.getBootstrapStatusProvider().isSetupComplete()) {
            return true;
        }
        if (this.eventPublisher != null && !this.spacePermissionManager.hasPermission("USECONFLUENCE", null, this.getAuthenticatedUser())) {
            this.eventPublisher.publish((Object)new NoConfluencePermissionEvent(this));
        }
        return this.spacePermissionManager.hasAllPermissions(this.getPermissionTypes(), null, this.getAuthenticatedUser());
    }

    protected List<String> getPermissionTypes() {
        return new ArrayList<String>(List.of("USECONFLUENCE"));
    }

    protected ConfluenceUser getAuthenticatedUser() {
        return AuthenticatedUserThreadLocal.get();
    }

    public ConfluenceUser getUserByName(String username) {
        return userCacheAccessor.getOrCompute(new UsernameCacheKey(username), () -> Optional.ofNullable(this.userAccessor.getUserByName(username))).orElse(null);
    }

    protected void addPermissionTypeTo(String permissionType, List<String> permissionTypes) {
        if (!permissionTypes.contains(permissionType)) {
            permissionTypes.add(permissionType);
        }
    }

    protected <TYPE> List<TYPE> getPermittedEntitiesOf(List<TYPE> entities) {
        return this.permissionManager.getPermittedEntities(this.getAuthenticatedUser(), Permission.VIEW, entities);
    }

    protected <TYPE> List<TYPE> getPermittedEntitiesOf(Iterator<TYPE> entities, int maxCount, List<? extends PermissionManager.Criterion> criteria) {
        return this.permissionManager.getPermittedEntities(this.getAuthenticatedUser(), Permission.VIEW, entities, maxCount, criteria);
    }

    protected <TYPE> List<TYPE> getPermittedEntitiesOf(Iterator<TYPE> entities, int maxCount) {
        return this.permissionManager.getPermittedEntities(this.getAuthenticatedUser(), Permission.VIEW, entities, maxCount);
    }

    @StrutsParameter
    public void setPreviousLoginDate(Date previousLoginDate) {
        this.previousLoginDate = previousLoginDate;
    }

    public Date getPreviousLoginDate() {
        return this.previousLoginDate != null ? this.previousLoginDate : this.retrievePreviousLoginDate();
    }

    private Date retrievePreviousLoginDate() {
        LoginInfo loginInfo;
        try {
            loginInfo = this.loginManager.getLoginInfo(this.getAuthenticatedUser());
        }
        catch (Exception e) {
            LOG.info("Problem retrieving loginInfo", (Throwable)e);
            return null;
        }
        return loginInfo != null ? loginInfo.getPreviousSuccessfulLoginDate() : null;
    }

    protected HttpServletRequest getActiveRequest() {
        if (this.request == null) {
            this.request = ServletActionContext.getRequest();
        }
        return this.request;
    }

    protected HttpServletResponse getActiveResponse() {
        if (this.response == null) {
            this.response = ServletActionContext.getResponse();
        }
        return this.response;
    }

    protected void addToHistory(ContentEntityObject content) {
        UserHistory checkHistory;
        HttpSession session = this.getActiveRequest().getSession();
        UserHistory history = (UserHistory)session.getAttribute("confluence.user.history");
        if (history == null) {
            history = new UserHistory(20);
            session.setAttribute("confluence.user.history", (Object)history);
        }
        if ((checkHistory = (UserHistory)session.getAttribute("confluence.user.history")) != null && LOG.isDebugEnabled()) {
            LOG.debug("Number of user history entries prior to adding new entry: {}", (Object)checkHistory.getContent().size());
            LOG.debug("User history stored in session: {}", (Object)session.getId());
        }
        history.addContentEntity(content);
        if (checkHistory != null && LOG.isDebugEnabled()) {
            LOG.debug("Number of user history entries after to adding new entry: {}", (Object)checkHistory.getContent().size());
        }
    }

    protected UserInterfaceState getUserInterfaceState() {
        if (this.userInterfaceState == null) {
            this.userInterfaceState = new UserInterfaceState(this.getAuthenticatedUser(), this.userAccessor);
        }
        return this.userInterfaceState;
    }

    public boolean isAnonymousUser() {
        return this.getAuthenticatedUser() == null;
    }

    public String getCancelResult() {
        return CANCEL;
    }

    protected Settings getGlobalSettings() {
        return this.globalSettingsManager != null ? this.globalSettingsManager.getGlobalSettings() : null;
    }

    public boolean isEmailVisible() {
        return this.permissionManager.isConfluenceAdministrator(this.getAuthenticatedUser()) || !this.getGlobalSettings().areEmailAddressesPrivate();
    }

    public void setSettingsManager(@Qualifier(value="globalSettingsManager") GlobalSettingsManager settingsManager) {
        this.globalSettingsManager = settingsManager;
    }

    public void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    @VisibleForTesting
    public void setBootstrapStatusProvider(BootstrapStatusProvider bootstrapStatusProvider) {
        this.bootstrapStatusProvider = bootstrapStatusProvider;
    }

    protected BootstrapStatusProvider getBootstrapStatusProvider() {
        return Objects.requireNonNullElseGet(this.bootstrapStatusProvider, BootstrapStatusProviderImpl::getInstance);
    }

    public void setSpacePermissionManager(SpacePermissionManager spacePermissionManager) {
        this.spacePermissionManager = spacePermissionManager;
    }

    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    public void setWebInterfaceManager(DynamicWebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public void setLabelManager(LabelManager labelManager) {
        this.labelManager = labelManager;
    }

    public void setLanguageManager(LanguageManager languageManager) {
        this.languageManager = languageManager;
    }

    public ThemeHelper getHelper() {
        if (this.globalHelper == null) {
            this.globalHelper = new GlobalHelper(this);
        }
        return this.globalHelper;
    }

    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    public Locale getLocale() {
        return this.localeManager.getLocale(this.getAuthenticatedUser());
    }

    public void addFieldError(String fieldName, String textKey, Object[] args) {
        this.addFieldError(fieldName, this.getText(textKey, PlainTextToHtmlConverter.encodeHtmlEntities(args)));
    }

    public void addActionError(String textKey, Object ... args) {
        this.addActionError(this.getText(textKey, PlainTextToHtmlConverter.encodeHtmlEntities(args)));
    }

    public void addActionMessage(String textKey, Object ... args) {
        this.addActionMessage(this.getText(textKey, PlainTextToHtmlConverter.encodeHtmlEntities(args)));
    }

    @Override
    public I18NBean getI18n() {
        return this.i18NBean;
    }

    public void setSystemInformationService(SystemInformationService systemInformationService) {
        this.systemInformationService = systemInformationService;
    }

    public void setLocaleManager(LocaleManager localeManager) {
        this.localeManager = localeManager;
    }

    public void setI18NBeanFactory(I18NBeanFactory i18NBeanFactory) {
        this.i18NBeanFactory = i18NBeanFactory;
    }

    @Override
    public void setMessageHolder(MessageHolder messageHolder) {
        this.messageHolder = messageHolder;
    }

    @Override
    @ActionViewData
    public MessageHolder getMessageHolder() {
        return this.messageHolder;
    }

    @ActionViewData
    public Collection<String> getActionErrors() {
        return super.getActionErrors();
    }

    @ActionViewData
    public Collection<String> getActionMessages() {
        return super.getActionMessages();
    }

    @ActionViewData
    public Map<String, List<String>> getFieldErrors() {
        return super.getFieldErrors();
    }

    public TimeZone getTimeZone() {
        if (this.getBootstrapStatusProvider().isSetupComplete() && this.getAuthenticatedUser() != null) {
            return this.userAccessor.getUserPreferences(this.getAuthenticatedUser()).getTimeZone();
        }
        return this.getDefaultTimeZone();
    }

    protected TimeZone getDefaultTimeZone() {
        if (this.timeZoneManager == null) {
            return TimeZone.getInstance(java.util.TimeZone.getDefault().getID());
        }
        return TimeZone.getInstance(this.timeZoneManager.getDefaultTimeZone().getID());
    }

    public DateFormatter getDateFormatter() {
        if (this.dateFormatter == null) {
            this.dateFormatter = new DateFormatter(this.getTimeZone(), this.formatSettingsManager, this.localeManager);
        }
        return this.dateFormatter;
    }

    public void setFormatSettingsManager(FormatSettingsManager formatSettingsManager) {
        this.formatSettingsManager = formatSettingsManager;
    }

    public void setI18NBean(I18NBean i18NBean) {
        this.i18NBean = i18NBean;
    }

    @Override
    public WebInterfaceContext getWebInterfaceContext() {
        DefaultWebInterfaceContext context = new DefaultWebInterfaceContext();
        context.setParameter("action", this);
        context.setCurrentUser(this.getAuthenticatedUser());
        ConfluenceActionSupport confluenceActionSupport = this;
        if (confluenceActionSupport instanceof UserAware) {
            UserAware userAware = (UserAware)((Object)confluenceActionSupport);
            context.setTargetedUser(FindUserHelper.getUser(userAware.getUser()));
        }
        AbstractPage page = null;
        ConfluenceActionSupport confluenceActionSupport2 = this;
        if (confluenceActionSupport2 instanceof PageAware) {
            PageAware pageAware = (PageAware)((Object)confluenceActionSupport2);
            page = pageAware.getPage();
            context.setPage(page);
        }
        Space space = null;
        ConfluenceActionSupport confluenceActionSupport3 = this;
        if (confluenceActionSupport3 instanceof Spaced) {
            Spaced spaced = (Spaced)((Object)confluenceActionSupport3);
            space = spaced.getSpace();
        } else if (page != null) {
            space = page.getLatestVersion().getSpace();
        }
        if (space != null) {
            context.setSpace(space);
            if (space.isPersonal()) {
                context.setTargetedUser(space.getCreator());
            }
        }
        return context;
    }

    public void setPluginAccessor(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public void setContentUiSupport(ContentUiSupport contentUiSupport) {
        this.contentUiSupport = contentUiSupport;
    }

    public void setTimeZoneManager(TimeZoneManager timeZoneManager) {
        this.timeZoneManager = timeZoneManager;
    }

    public void setConfluenceAccessManager(ConfluenceAccessManager confluenceAccessManager) {
        this.confluenceAccessManager = confluenceAccessManager;
    }

    public void setAccessModeService(AccessModeService accessModeService) {
        this.accessModeService = accessModeService;
    }

    public void setStrutsHelper(StrutsHelper strutsHelper) {
        this.strutsHelper = strutsHelper;
    }
}

