/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.event.events.analytics.LicenseCheckFailedEvent;
import com.atlassian.confluence.json.json.JsonObject;
import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.pages.actions.AbstractPreviewPageAction;
import com.atlassian.confluence.pages.actions.ConvertPageToBlogPostAction;
import com.atlassian.confluence.pages.actions.CopyPageAction;
import com.atlassian.confluence.pages.actions.CreateBlogPostAction;
import com.atlassian.confluence.pages.actions.CreatePageAction;
import com.atlassian.confluence.pages.actions.EditBlogPostAction;
import com.atlassian.confluence.pages.actions.EditPageAction;
import com.atlassian.confluence.pages.actions.MoveAttachmentAction;
import com.atlassian.confluence.pages.actions.MoveBlogPostAction;
import com.atlassian.confluence.pages.actions.MovePageAction;
import com.atlassian.confluence.pages.actions.RemoveAttachedFileAction;
import com.atlassian.confluence.pages.actions.RemoveAttachedFileVersionAction;
import com.atlassian.confluence.pages.actions.RemoveCommentAction;
import com.atlassian.confluence.pages.actions.RemoveHistoricalVersionAction;
import com.atlassian.confluence.pages.actions.RemovePageAction;
import com.atlassian.confluence.spaces.actions.AbstractCreateSpaceAction;
import com.atlassian.confluence.spaces.actions.CreatePersonalSpaceAction;
import com.atlassian.confluence.spaces.actions.EditSpaceAction;
import com.atlassian.confluence.spaces.actions.ImportPagesAction;
import com.atlassian.confluence.spaces.actions.SpaceAvailableAction;
import com.atlassian.confluence.user.actions.SignUpAction;
import com.atlassian.confluence.util.GeneralUtil;
import com.atlassian.confluence.util.MemoizingComponentReference;
import com.atlassian.confluence.util.UserChecker;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.spring.container.ContainerManager;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.struts2.ActionContext;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.interceptor.Interceptor;

public class ConfluenceLicenseInterceptor
implements Interceptor {
    private final Supplier<EventPublisher> eventPublisher = MemoizingComponentReference.containerComponent("eventPublisher");
    private final Supplier<UserChecker> userChecker = MemoizingComponentReference.containerComponent("userChecker");
    private final Supplier<LicenseService> licenseService = MemoizingComponentReference.containerComponent("licenseService");
    private static final String EDITOR_ACTION_CLASSNAME = "com.atlassian.confluence.plugins.editorloader.EditorAction";
    private static final String LICENSE_EXPIRED_REASON = "licenseExpired";
    private static final String LICENSE_USERS_EXCEEDED_REASON = "licenseUsersExceeded";
    private static final String LICENSE_CHECK_FAILED = "licenseCheckFailed";

    public void destroy() {
    }

    public void init() {
    }

    public String intercept(ActionInvocation actionInvocation) throws Exception {
        String failureReason;
        if (actionInvocation.getAction() instanceof ConfluenceActionSupport && this.shouldCheckForLicense(actionInvocation) && (failureReason = this.checkLicenseFailure(actionInvocation)) != null) {
            return this.handleResponse(failureReason, actionInvocation.getInvocationContext());
        }
        return actionInvocation.invoke();
    }

    private UserChecker getUserChecker() {
        if (!ContainerManager.isContainerSetup()) {
            return null;
        }
        return this.userChecker.get();
    }

    private EventPublisher getEventPublisher() {
        if (!ContainerManager.isContainerSetup()) {
            return null;
        }
        return this.eventPublisher.get();
    }

    private String checkLicenseFailure(ActionInvocation actionInvocation) {
        if (this.licenseService.get().retrieve().isExpired()) {
            this.publishAnalyticsEvent(LICENSE_EXPIRED_REASON, actionInvocation);
            return "licenseexpired";
        }
        if (this.getUserChecker() != null && this.getUserChecker().hasTooManyUsers()) {
            this.publishAnalyticsEvent(LICENSE_USERS_EXCEEDED_REASON, actionInvocation);
            return "licenseusersexceeded";
        }
        return null;
    }

    private boolean shouldCheckForLicense(ActionInvocation actionInvocation) {
        Set<Class> licensedActions = Set.of(SpaceAvailableAction.class, CreatePersonalSpaceAction.class, AbstractCreateSpaceAction.class, RemoveCommentAction.class, AbstractPreviewPageAction.class, CopyPageAction.class, SignUpAction.class, CreatePageAction.class, EditPageAction.class, CreateBlogPostAction.class, EditBlogPostAction.class, EditSpaceAction.class, ImportPagesAction.class, MoveAttachmentAction.class, MoveBlogPostAction.class, MovePageAction.class, RemoveAttachedFileAction.class, RemoveHistoricalVersionAction.class, RemoveAttachedFileVersionAction.class, RemovePageAction.class, ConvertPageToBlogPostAction.class);
        Object action = actionInvocation.getAction();
        return GeneralUtil.isSetupComplete() && licensedActions.stream().anyMatch(clazz -> clazz.isInstance(action));
    }

    private void publishAnalyticsEvent(String reason, ActionInvocation actionInvocation) {
        String actionClassName = actionInvocation.getAction().getClass().getName();
        if (this.shouldPublishAnalyticsEvent(actionClassName)) {
            this.getEventPublisher().publish((Object)new LicenseCheckFailedEvent(reason, actionClassName));
        }
    }

    private boolean shouldPublishAnalyticsEvent(String actionClassName) {
        return this.getEventPublisher() != null && !actionClassName.equals(EDITOR_ACTION_CLASSNAME);
    }

    private String handleResponse(String failureReason, ActionContext actionContext) throws IOException {
        HttpServletRequest request = actionContext.getServletRequest();
        HttpServletResponse response = actionContext.getServletResponse();
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader != null && acceptHeader.contains("application/json")) {
            this.sendJsonResponse(response, failureReason);
            return null;
        }
        return failureReason;
    }

    private void sendJsonResponse(HttpServletResponse response, String failureReason) throws IOException {
        response.setContentType("application/json");
        JsonObject jsonResponse = new JsonObject().setProperty(LICENSE_CHECK_FAILED, failureReason);
        response.getWriter().write(jsonResponse.serialize());
    }
}

