/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.config.ConfigurationException;
import com.atlassian.confluence.core.ConfluenceSidManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;

public class DatabaseSidManager
implements ConfluenceSidManager {
    private PluginSettings globalSettings;
    private ConfluenceSidManager bootstrapSidManager;
    @VisibleForTesting
    static final String CONFLUENCE_SERVER_ID = "confluence.server.id";

    public void initSid() throws ConfigurationException {
        if (this.isSidSet()) {
            throw new ConfigurationException("Server ID already initialised");
        }
        if (!this.bootstrapSidManager.isSidSet()) {
            throw new ConfigurationException("No SID found from setup");
        }
        this.globalSettings.put(CONFLUENCE_SERVER_ID, (Object)this.bootstrapSidManager.getSid());
    }

    public String getSid() throws ConfigurationException {
        return (String)this.globalSettings.get(CONFLUENCE_SERVER_ID);
    }

    public boolean isSidSet() throws ConfigurationException {
        return this.getSid() != null;
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public void setBootstrapSidManager(ConfluenceSidManager bootstrapSidManager) {
        this.bootstrapSidManager = bootstrapSidManager;
    }
}

