/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.confluence.core.TimeZone;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import io.atlassian.util.concurrent.Lazy;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.function.Supplier;

public class DateFormatter {
    private final TimeZone timeZone;
    private final FormatSettingsManager formatSettingsManager;
    private final LocaleManager localeManager;
    private final Supplier<DateFormat> dateFormat;
    private final Supplier<DateFormat> dateTimeFormat;
    private final Supplier<DateFormat> timeFormat;
    private final Supplier<DateFormat> blogDateFormat;
    private final Supplier<DateFormat> serverDateFormat;
    private final Supplier<DateFormat> serverDateTimeFormat;

    public DateFormatter(TimeZone timeZone, FormatSettingsManager formatSettingsManager, LocaleManager localeManager) {
        this.formatSettingsManager = formatSettingsManager;
        this.localeManager = localeManager;
        this.timeZone = timeZone;
        this.dateFormat = Lazy.supplier(() -> this.createFormat(formatSettingsManager.getDateFormat()));
        this.dateTimeFormat = Lazy.supplier(() -> this.createFormat(formatSettingsManager.getDateTimeFormat()));
        this.timeFormat = Lazy.supplier(() -> this.createFormat(formatSettingsManager.getTimeFormat()));
        this.blogDateFormat = Lazy.supplier(() -> this.createServerFormat("MMM dd, yyyy"));
        this.serverDateFormat = Lazy.supplier(() -> this.createServerFormat(formatSettingsManager.getDateFormat()));
        this.serverDateTimeFormat = Lazy.supplier(() -> this.createServerFormat(formatSettingsManager.getDateTimeFormat()));
    }

    public DateFormatter(java.util.TimeZone timeZone, FormatSettingsManager formatSettingsManager, LocaleManager localeManager) {
        this(TimeZone.getInstance(timeZone), formatSettingsManager, localeManager);
    }

    public String format(Date date) {
        return DateFormatter.formatWith(this.dateFormat, date);
    }

    public String formatDateTime(Date date) {
        return DateFormatter.formatWith(this.dateTimeFormat, date);
    }

    public String formatDateTime(Instant instant) {
        return this.formatDateTime(Date.from(instant));
    }

    public String formatTime(Date date) {
        return DateFormatter.formatWith(this.timeFormat, date);
    }

    public String formatTimeMedium(Date date) {
        return DateFormatter.formatWith(DateFormat.getTimeInstance(2, this.getCurrentUserLocale()), date);
    }

    public String formatDateFull(Date date) {
        DateFormat format = DateFormat.getDateInstance(0, this.getCurrentUserLocale());
        format.setLenient(false);
        format.setTimeZone(this.timeZone.getWrappedTimeZone());
        return DateFormatter.formatWith(format, date);
    }

    public String format(int formatOption, Date date) {
        DateFormat format = DateFormat.getDateInstance(formatOption, this.getCurrentUserLocale());
        format.setLenient(false);
        format.setTimeZone(this.timeZone.getWrappedTimeZone());
        return DateFormatter.formatWith(format, date);
    }

    public String formatServerDate(Date date) {
        return DateFormatter.formatWith(this.serverDateFormat, date);
    }

    public String formatServerDateWithUserLocale(int formatOption, Date date) {
        DateFormat format = DateFormat.getDateInstance(formatOption, this.getCurrentUserLocale());
        format.setLenient(false);
        return DateFormatter.formatWith(format, date);
    }

    public String formatServerDateTime(Date date) {
        return DateFormatter.formatWith(this.serverDateTimeFormat, date);
    }

    public String formatBlogDate(Date date) {
        return DateFormatter.formatWith(this.blogDateFormat, date);
    }

    public String formatServerDateFull(Date date) {
        DateFormat format = DateFormat.getDateInstance(0, this.getCurrentUserLocale());
        format.setLenient(false);
        format.setTimeZone(TimeZone.getDefault().getWrappedTimeZone());
        return DateFormatter.formatWith(format, date);
    }

    public String formatGivenString(String formatString, Date date) {
        DateFormat format = this.createFormat(formatString);
        return DateFormatter.formatWith(format, date);
    }

    public String getCurrentDateTime() {
        return this.formatDateTime(new Date());
    }

    public String getCurrentDate() {
        return this.format(new Date());
    }

    public String getDateForBlogPost(Date date) {
        DateFormat format = this.createFormat(this.formatSettingsManager.getEditorBlogPostDate());
        return DateFormatter.formatWith(format, date);
    }

    public String getTimeForBlogPost(Date date) {
        DateFormat format = this.createFormat(this.formatSettingsManager.getEditorBlogPostTime());
        return DateFormatter.formatWith(format, date);
    }

    private static String formatWith(Supplier<DateFormat> format, Date date) {
        return DateFormatter.formatWith(format.get(), date);
    }

    private static String formatWith(DateFormat format, Date date) {
        try {
            return format.format(date);
        }
        catch (RuntimeException e) {
            return "";
        }
    }

    private DateFormat createFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, this.getCurrentUserLocale());
        format.setLenient(false);
        format.setTimeZone(this.timeZone.getWrappedTimeZone());
        return format;
    }

    private DateFormat createServerFormat(String pattern) {
        SimpleDateFormat format = new SimpleDateFormat(pattern, this.getCurrentUserLocale());
        format.setLenient(false);
        format.setTimeZone(TimeZone.getDefault().getWrappedTimeZone());
        return format;
    }

    private Locale getCurrentUserLocale() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        Locale locale = this.localeManager.getLocale(user);
        if (locale != null) {
            return locale;
        }
        return Locale.getDefault();
    }

    public Calendar getCalendar() {
        return Calendar.getInstance(this.timeZone.getWrappedTimeZone());
    }

    public TimeZone getTimeZone() {
        return this.timeZone;
    }

    public static String formatMillis(long millis) {
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss.S");
        format.setTimeZone(java.util.TimeZone.getTimeZone("UTC"));
        String result = format.format(new Date(millis));
        result = result.replaceFirst("^00:", "");
        return result;
    }
}

