/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.CustomPageSettings;
import com.atlassian.confluence.core.CustomPageSettingsManager;
import com.atlassian.confluence.dmz.json.ConfluenceJsonObjectMapper;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;

public class DefaultCustomPageSettingsManager
implements CustomPageSettingsManager {
    private final PluginSettings globalPluginSettings;
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ConfluenceJsonObjectMapper mapper = new ConfluenceJsonObjectMapper();
    private static final String CUSTOM_PAGE_SETTINGS_KEY = "com.atlassian.core.CustomPageSettings";

    public DefaultCustomPageSettingsManager(PluginSettingsFactory pluginSettingsFactory) {
        this.globalPluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    @Override
    public CustomPageSettings retrieveSettings(String spaceKey) {
        return this.getSettingsFromPluginSettings(this.pluginSettingsFactory.createSettingsForKey(spaceKey));
    }

    @Override
    public CustomPageSettings retrieveSettings() {
        return this.getSettingsFromPluginSettings(this.globalPluginSettings);
    }

    @Override
    public void saveSettings(String spaceKey, CustomPageSettings settings) {
        this.saveSettingsInPluginSettings(this.pluginSettingsFactory.createSettingsForKey(spaceKey), settings);
    }

    @Override
    public void saveSettings(CustomPageSettings settings) {
        this.saveSettingsInPluginSettings(this.globalPluginSettings, settings);
    }

    private CustomPageSettings getSettingsFromPluginSettings(PluginSettings pluginSettings) {
        String customPageSettingsJson = (String)pluginSettings.get(CUSTOM_PAGE_SETTINGS_KEY);
        CustomPageSettings customPageSettings = this.mapper.deserialize(customPageSettingsJson, CustomPageSettings.class);
        return customPageSettings == null ? CustomPageSettings.DEFAULT_SETTINGS : customPageSettings;
    }

    private void saveSettingsInPluginSettings(PluginSettings pluginSettings, CustomPageSettings settings) {
        pluginSettings.put(CUSTOM_PAGE_SETTINGS_KEY, (Object)this.mapper.serialize(settings));
    }
}

