/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DefaultFormatSettingsManager
implements FormatSettingsManager {
    static final String SETTING_KEY = DefaultFormatSettingsManager.class.getName();
    static final String DATE_FORMAT = "dateFormat";
    static final String TIME_FORMAT = "timeFormat";
    static final String DATE_TIME_FORMAT = "dateTimeFormat";
    static final String LONG_NUMBER_FORMAT = "longNumberFormat";
    static final String DECIMAL_NUMBER_FORMAT = "decimalNumberFormat";
    private PluginSettings globalSettings;
    public static final String DEFAULT_DATE_PATTERN = "MMM dd, yyyy";
    public static final String DEFAULT_DATE_TIME_PATTERN = "MMM dd, yyyy HH:mm";
    public static final String BLOG_DATE_PATTERN = "MMM dd, yyyy";
    public static final String EDITOR_BLOG_DATE_PATTERN = "yyyy-MM-dd";
    public static final String EDITOR_BLOG_TIME_PATTERN = "HH:mm";
    public static final String DEFAULT_TIME_PATTERN = "h:mm a";
    public static final String DEFAULT_LONG_NUMBER_PATTERN = "###############";
    public static final String DEFAULT_DECIMAL_NUMBER_PATTERN = "###############.##########";

    private Map<String, String> retrieveSettings() {
        Object settings = this.globalSettings.get(SETTING_KEY);
        if (!(settings instanceof Map)) {
            return new HashMap<String, String>();
        }
        Map typedSettings = (Map)settings;
        return typedSettings;
    }

    private String getSetting(String settingName, String defaultValue) {
        Map<String, String> settings = this.retrieveSettings();
        return Objects.requireNonNullElse(settings.get(settingName), defaultValue);
    }

    private void setSetting(String settingName, String value) {
        Map<String, String> settings = this.retrieveSettings();
        settings.put(settingName, value);
        this.globalSettings.put(SETTING_KEY, settings);
    }

    @Override
    public String getDateFormat() {
        return this.getSetting(DATE_FORMAT, "MMM dd, yyyy");
    }

    @Override
    public void setDateFormat(String pattern) {
        this.setSetting(DATE_FORMAT, pattern);
    }

    @Override
    public String getTimeFormat() {
        return this.getSetting(TIME_FORMAT, DEFAULT_TIME_PATTERN);
    }

    @Override
    public void setTimeFormat(String pattern) {
        this.setSetting(TIME_FORMAT, pattern);
    }

    @Override
    public String getDateTimeFormat() {
        return this.getSetting(DATE_TIME_FORMAT, DEFAULT_DATE_TIME_PATTERN);
    }

    @Override
    public void setDateTimeFormat(String pattern) {
        this.setSetting(DATE_TIME_FORMAT, pattern);
    }

    @Override
    public String getEditorBlogPostDate() {
        return EDITOR_BLOG_DATE_PATTERN;
    }

    @Override
    public String getEditorBlogPostTime() {
        return EDITOR_BLOG_TIME_PATTERN;
    }

    @Override
    public String getLongNumberFormat() {
        return this.getSetting(LONG_NUMBER_FORMAT, DEFAULT_LONG_NUMBER_PATTERN);
    }

    @Override
    public void setLongNumberFormat(String pattern) {
        this.setSetting(LONG_NUMBER_FORMAT, pattern);
    }

    @Override
    public String getDecimalNumberFormat() {
        return this.getSetting(DECIMAL_NUMBER_FORMAT, DEFAULT_DECIMAL_NUMBER_PATTERN);
    }

    @Override
    public void setDecimalNumberFormat(String pattern) {
        this.setSetting(DECIMAL_NUMBER_FORMAT, pattern);
    }

    public void setPluginSettingsFactory(PluginSettingsFactory pluginSettingsFactory) {
        this.globalSettings = pluginSettingsFactory.createGlobalSettings();
    }
}

