/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Type;

@NamedQueries(value={@NamedQuery(name="confluence.persistentdecorator_findByNameAndSpaceKey", query="from PersistentDecorator decorator where decorator.name = :name and decorator.spaceKey = :spaceKey"), @NamedQuery(name="confluence.persistentdecorator_findGlobalDecoratorByName", query="from PersistentDecorator decorator where decorator.name = :name and decorator.spaceKey is null"), @NamedQuery(name="confluence.persistentdecorator_findBySpaceKey", query="from PersistentDecorator decorator where decorator.spaceKey = :spaceKey"), @NamedQuery(name="confluence.persistentdecorator_findGlobalDecorators", query="from PersistentDecorator decorator where decorator.spaceKey is null")})
@Entity
@Table(name="DECORATOR", indexes={@Index(name="dec_key_idx", columnList="SPACEKEY"), @Index(name="dec_name_idx", columnList="DECORATORNAME")})
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Proxy(lazy=false)
public class PersistentDecorator
implements Serializable {
    @Id
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    @Column(name="DECORATORID", updatable=false)
    private long id;
    @Column(name="SPACEKEY")
    private String spaceKey;
    @Column(name="DECORATORNAME")
    private String name;
    @Column(name="BODY", length=100000)
    @Type(type="com.atlassian.confluence.core.persistence.hibernate.CustomClobType")
    private String body;
    @Column(name="LASTMODDATE")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date lastModificationDate;

    public PersistentDecorator() {
        this.lastModificationDate = new Date();
    }

    public PersistentDecorator(@Nullable String spaceKey, String name, String body, Date lastModificationDate) {
        this.spaceKey = spaceKey;
        this.name = name;
        this.body = body;
        this.lastModificationDate = lastModificationDate;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getSpaceKey() {
        return this.spaceKey;
    }

    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
        this.lastModificationDate = new Date();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentDecorator that = (PersistentDecorator)o;
        return this.id == that.id && Objects.equals(this.spaceKey, that.spaceKey) && Objects.equals(this.name, that.name) && Objects.equals(this.body, that.body) && Objects.equals(this.lastModificationDate, that.lastModificationDate);
    }

    public int hashCode() {
        int result = Long.hashCode(this.id);
        result = 29 * result + (this.spaceKey != null ? this.spaceKey.hashCode() : 0);
        result = 29 * result + this.name.hashCode();
        result = 29 * result + (this.body != null ? this.body.hashCode() : 0);
        result = 29 * result + (this.lastModificationDate != null ? this.lastModificationDate.hashCode() : 0);
        return result;
    }

    public Date getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(Date lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }
}

