/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import org.apache.struts2.ActionInvocation;
import org.apache.struts2.interceptor.LoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultLoggingInterceptor
extends LoggingInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ResultLoggingInterceptor.class);

    public String intercept(ActionInvocation invocation) throws Exception {
        String result = super.intercept(invocation);
        this.after(invocation, result);
        return result;
    }

    private void after(ActionInvocation actionInvocation, String result) throws Exception {
        this.logMessage(actionInvocation, "Result was \"" + result + "\" for action ");
    }

    private void logMessage(ActionInvocation invocation, String baseMessage) {
        if (logger.isInfoEnabled()) {
            StringBuilder message = new StringBuilder(baseMessage);
            String namespace = invocation.getProxy().getNamespace();
            if (namespace != null && !namespace.trim().isEmpty()) {
                message.append(namespace).append("/");
            }
            message.append(invocation.getProxy().getActionName());
            logger.info(message.toString());
        }
    }
}

