/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core;

import com.atlassian.confluence.core.AnnotatedEntityObject;
import com.atlassian.confluence.core.NotExportable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.Table;
import java.util.Date;
import org.hibernate.annotations.ColumnDefault;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Type;

@NamedQueries(value={@NamedQuery(name="confluence.confversion_findByBuildNumber", query="from VersionHistory vh where vh.buildNumber = :buildNumber order by vh.installationDate desc"), @NamedQuery(name="confluence.confversion_findUpgradeHistory", query="from VersionHistory vh order by vh.installationDate desc")})
@Entity
@Table(name="CONFVERSION")
@Proxy(lazy=false)
public class VersionHistory
extends AnnotatedEntityObject
implements NotExportable {
    private int buildNumber;
    private Date installationDate;
    private String versionTag;
    private boolean finalized;

    public VersionHistory() {
    }

    public VersionHistory(int buildNumber, Date installationDate) {
        this(buildNumber, installationDate, null);
    }

    public VersionHistory(int buildNumber, Date installationDate, String versionTag) {
        this.buildNumber = buildNumber;
        this.installationDate = installationDate;
        this.versionTag = versionTag;
    }

    @Id
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    @Column(name="CONFVERSIONID", updatable=false)
    public long getId() {
        return super.getId();
    }

    @Column(name="BUILDNUMBER", nullable=false, unique=true)
    public int getBuildNumber() {
        return this.buildNumber;
    }

    @Type(type="org.hibernate.type.YesNoType")
    @ColumnDefault(value="'N'")
    @Column(name="FINALIZED", nullable=false)
    public boolean isFinalized() {
        return this.finalized;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    @Column(name="INSTALLDATE")
    public Date getInstallationDate() {
        return this.installationDate;
    }

    public void setFinalized(boolean finalized) {
        this.finalized = finalized;
    }

    public void setInstallationDate(Date installationDate) {
        this.installationDate = installationDate;
    }

    @Column(name="VERSIONTAG")
    public String getVersionTag() {
        return this.versionTag;
    }

    public void setVersionTag(String versionTag) {
        this.versionTag = versionTag;
    }
}

