/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.themes.ColorSchemeBean;
import com.atlassian.confluence.themes.ColourScheme;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.util.ColourUtils;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@UnrestrictedAccess
public class ColorsStylesheetAction
extends ConfluenceActionSupport {
    private ColorSchemeBean colorScheme;
    private ColourSchemeManager colourSchemeManager;
    private ColourUtils colourUtils = new ColourUtils();
    private String spaceKey;

    @PermittedMethods(value={HttpMethod.GET})
    public String execute() throws Exception {
        this.colorScheme = new ColorSchemeBean(this.getActiveColourScheme(this.spaceKey));
        return "success";
    }

    private ColourScheme getActiveColourScheme(String spaceKey) {
        if (StringUtils.isNotEmpty((CharSequence)spaceKey)) {
            return this.colourSchemeManager.getSpaceColourScheme(spaceKey);
        }
        return this.colourSchemeManager.getGlobalColourScheme();
    }

    public ColorSchemeBean getColourScheme() {
        return this.colorScheme;
    }

    public ColorSchemeBean getColorScheme() {
        return this.colorScheme;
    }

    public void setColourSchemeManager(ColourSchemeManager colourSchemeManager) {
        this.colourSchemeManager = colourSchemeManager;
    }

    @StrutsParameter
    public void setSpaceKey(String spaceKey) {
        this.spaceKey = spaceKey;
    }

    public ColourUtils getColourUtils() {
        return this.colourUtils;
    }

    @Override
    public boolean isPermitted() {
        return this.spaceKey == null ? true : super.isPermitted();
    }
}

