/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.actions;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.core.actions.LoginExemptionHelper;
import com.atlassian.confluence.servlet.ServletRequestAttributes;
import com.atlassian.confluence.struts.soy.ActionViewData;
import com.atlassian.confluence.struts.soy.ActionViewDataMappings;
import com.atlassian.confluence.themes.GlobalHelper;
import com.atlassian.confluence.themes.Theme;
import com.atlassian.confluence.themes.ThemeManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.actions.AuthenticationHelper;
import com.atlassian.confluence.util.SeraphUtils;
import com.atlassian.johnson.Johnson;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.struts.httpmethod.HttpMethod;
import com.atlassian.struts.httpmethod.PermittedMethods;
import com.google.common.collect.ImmutableMap;
import jakarta.servlet.ServletRequest;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class FourOhFourAction
extends ConfluenceActionSupport {
    private static final Logger log = LoggerFactory.getLogger(FourOhFourAction.class);
    private ThemeManager themeManager;
    private LoginExemptionHelper loginExemptionHelper;

    @ActionViewDataMappings
    public Map<String, Object> getFourOhFourActionViewDataMappings() {
        GlobalHelper globalHelper = new GlobalHelper(this.getHelper().getAction());
        return ImmutableMap.builder().put((Object)"request", (Object)this.getActiveRequest()).put((Object)"breadcrumbs", globalHelper.getBreadcrumbs()).put((Object)"ellipsisCrumbs", globalHelper.getEllipsisCrumbs(globalHelper.getBreadcrumbs())).build();
    }

    @PermittedMethods(value={HttpMethod.ANY_METHOD})
    @XsrfProtectionExcluded
    public String execute() throws Exception {
        this.getActiveResponse().setStatus(404);
        if (!this.isSetupComplete()) {
            return "setup-success";
        }
        String originalUrlPathFromErrorUri = this.getOriginalUrlPathFromErrorUri();
        if (!(!Objects.isNull(this.getAuthenticatedUser()) || this.canAnonymousUseConfluence() || this.isStaticResource(originalUrlPathFromErrorUri) || Johnson.getConfig().isIgnoredPath(originalUrlPathFromErrorUri) || this.loginExemptionHelper.isUrlPathExempted(originalUrlPathFromErrorUri))) {
            return "login";
        }
        return super.execute();
    }

    @Override
    public boolean isPermitted() {
        return true;
    }

    public Theme getTheme() {
        return this.themeManager.getGlobalTheme();
    }

    public String getLoginUrl() {
        String originalUrl = StringUtils.defaultString((String)((String)this.getActiveRequest().getAttribute("atlassian.core.seraph.original.url")));
        if (originalUrl.isEmpty() || originalUrl.equals("/fourohfour.action")) {
            this.configureSeraphWithErrorRequestUrlAsOriginalUrl();
        }
        return AuthenticationHelper.getLoginUrl();
    }

    public void setThemeManager(ThemeManager themeManager) {
        this.themeManager = themeManager;
    }

    public void setLoginExemptionHelper(LoginExemptionHelper loginExemptionHelper) {
        this.loginExemptionHelper = loginExemptionHelper;
    }

    private boolean isSetupComplete() {
        return ContainerManager.isContainerSetup() && this.getBootstrapStatusProvider().isSetupComplete();
    }

    private void configureSeraphWithErrorRequestUrlAsOriginalUrl() {
        String pathFromOriginalUrl = this.getOriginalUrlPathFromErrorUri();
        this.getActiveRequest().setAttribute("atlassian.core.seraph.original.url", (Object)pathFromOriginalUrl);
        log.debug("No {} was found in the request. Storing path: {}", (Object)"atlassian.core.seraph.original.url", (Object)pathFromOriginalUrl);
    }

    private String getOriginalUrlPathFromErrorUri() {
        String originalURL = ServletRequestAttributes.getErrorRequestUri((ServletRequest)this.getActiveRequest());
        return SeraphUtils.stripContextPathFromRequestURL(this.getActiveRequest(), StringUtils.defaultString((String)originalURL));
    }

    private boolean isStaticResource(String pathFromOriginalUrl) {
        return pathFromOriginalUrl.startsWith("/s/");
    }

    private boolean canAnonymousUseConfluence() {
        return this.confluenceAccessManager.getUserAccessStatusNoExemptions((ConfluenceUser)null).canUseConfluence();
    }

    @ActionViewData
    public String getRequestUri() {
        return this.getActiveRequest().getRequestURI();
    }

    @ActionViewData
    public String getQueryString() {
        return this.getActiveRequest().getQueryString();
    }
}

