/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.actions;

import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.descriptors.ConfluenceWebItemModuleDescriptor;
import com.atlassian.confluence.web.Cookies;
import com.atlassian.plugin.web.api.DynamicWebInterfaceManager;
import com.atlassian.plugin.web.api.descriptors.WebItemModuleDescriptor;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;

public class RedirectActionHelper {
    private final DynamicWebInterfaceManager webInterfaceManager;

    public RedirectActionHelper(DynamicWebInterfaceManager webInterfaceManager) {
        this.webInterfaceManager = webInterfaceManager;
    }

    public String getRedirectUrlAndUpdateCookies(String cookieName, String webItemLocation, WebInterfaceContext context) throws Exception {
        List availableWebItems = this.webInterfaceManager.getDisplayableItems(webItemLocation, context.toMap());
        if (availableWebItems.isEmpty()) {
            ServletActionContext.getResponse().sendError(404);
            return null;
        }
        ConfluenceWebItemModuleDescriptor redirectTo = (ConfluenceWebItemModuleDescriptor)this.getItemToRedirectTo(availableWebItems, cookieName);
        String value = redirectTo.getKey();
        Cookies.setResponseCookie(cookieName, value);
        return redirectTo.getLink().getRenderedUrl(context.toMap());
    }

    private WebItemModuleDescriptor getItemToRedirectTo(List<? extends WebItemModuleDescriptor> availableWebItems, String cookieName) {
        String cookieValue = Cookies.getCookieValue(cookieName);
        if (StringUtils.isNotEmpty((CharSequence)cookieValue)) {
            for (WebItemModuleDescriptor webItemModuleDescriptor : availableWebItems) {
                if (!webItemModuleDescriptor.getKey().equals(cookieValue)) continue;
                return webItemModuleDescriptor;
            }
        }
        return availableWebItems.get(0);
    }
}

