/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.listeners;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.Addressable;
import com.atlassian.confluence.event.events.types.ConfluenceEntityUpdated;
import com.atlassian.confluence.search.ChangeIndexer;
import com.atlassian.event.api.EventListener;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;

public class TitleChangeListener {
    private final ChangeIndexer changeIndexer;

    public TitleChangeListener(ChangeIndexer changeIndexer) {
        this.changeIndexer = changeIndexer;
    }

    @EventListener
    public void handleEvent(ConfluenceEntityUpdated updated) {
        TitleChangeListener.zip(Addressable.of(updated.getOld()), Addressable.of(updated.getNew()), (oldEntity, newEntity) -> {
            if (newEntity instanceof Searchable) {
                Searchable searchable = (Searchable)newEntity;
                if (TitleChangeListener.titleChanged(oldEntity, newEntity)) {
                    this.changeIndexer.reIndexAllVersions(searchable);
                }
            }
        });
    }

    private static boolean titleChanged(Addressable oldEntity, Addressable newEntity) {
        return !Objects.equals(oldEntity.getDisplayTitle(), newEntity.getDisplayTitle());
    }

    private static <A, B> void zip(Optional<A> oa, Optional<B> ob, BiConsumer<A, B> c) {
        oa.ifPresent(a -> ob.ifPresent(b -> c.accept(a, b)));
    }
}

