/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.hibernate;

import com.atlassian.confluence.api.model.content.ContentStatus;
import com.atlassian.confluence.api.model.pagination.ContentCursor;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.persistence.hibernate.HibernateObjectDao;
import com.atlassian.confluence.spaces.Space;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public abstract class ConfluenceHibernateObjectDao<T extends ConfluenceEntityObject>
extends HibernateObjectDao<T> {
    @Override
    protected void updateModificationData(T entityObject) {
        this.updateModificationData(entityObject, AuthenticatedUserThreadLocal.get());
        super.updateModificationData(entityObject);
    }

    private void updateModificationData(T entityObject, ConfluenceUser lastModifier) {
        ((ConfluenceEntityObject)entityObject).setLastModifier(lastModifier);
        if (!((ConfluenceEntityObject)entityObject).isPersistent() && ((ConfluenceEntityObject)entityObject).getCreator() == null) {
            ((ConfluenceEntityObject)entityObject).setCreator(lastModifier);
        }
    }

    protected List<T> scanFilteredContents(Class clazz, List<ContentStatus> statuses, LimitedRequest pageRequest) {
        List<String> contentStatusStringList = this.getContentStatusStringList(statuses);
        Function<LimitedRequest, List> pageSearch = request -> {
            ContentCursor contentCursor = (ContentCursor)request.getCursor();
            if (contentCursor.getContentId() == null) {
                String queryName = contentCursor.isReverse() ? "confluence.content_findByCursorFirstReverse" : "confluence.content_findByCursorFirstForward";
                return this.findNamedQueryStringParams(queryName, HibernateObjectDao.Cacheability.NOT_CACHEABLE, (LimitedRequest)request, (Object)"statuses", (Object)contentStatusStringList, (Object)"contenttype", (Object)clazz);
            }
            String queryName = contentCursor.isReverse() ? "confluence.content_findByCursorReverse" : "confluence.content_findByCursorForward";
            return this.findNamedQueryStringParams(queryName, HibernateObjectDao.Cacheability.NOT_CACHEABLE, (LimitedRequest)request, (Object)"contentid", (Object)contentCursor.getContentId(), (Object)"statuses", (Object)contentStatusStringList, (Object)"contenttype", (Object)clazz);
        };
        return pageSearch.apply(pageRequest);
    }

    protected List<T> scanFilteredContents(Class clazz, Space space, List<ContentStatus> statuses, LimitedRequest pageRequest) {
        List<String> contentStatusStringList = this.getContentStatusStringList(statuses);
        Function<LimitedRequest, List> pageSearch = request -> {
            ContentCursor contentCursor = (ContentCursor)request.getCursor();
            if (contentCursor.getContentId() == null) {
                String queryName = contentCursor.isReverse() ? "confluence.content_findBySpaceAndCursorFirstReverse" : "confluence.content_findBySpaceAndCursorFirstForward";
                return this.findNamedQueryStringParams(queryName, HibernateObjectDao.Cacheability.NOT_CACHEABLE, (LimitedRequest)request, (Object)"spaceid", (Object)space.getId(), (Object)"contenttype", (Object)clazz, (Object)"statuses", (Object)contentStatusStringList);
            }
            String queryName = contentCursor.isReverse() ? "confluence.content_findBySpaceAndCursorReverse" : "confluence.content_findBySpaceAndCursorForward";
            return this.findNamedQueryStringParams(queryName, HibernateObjectDao.Cacheability.NOT_CACHEABLE, (LimitedRequest)request, (Object)"spaceid", (Object)space.getId(), (Object)"contentid", (Object)contentCursor.getContentId(), (Object)"contenttype", (Object)clazz, (Object)"statuses", (Object)contentStatusStringList);
        };
        return pageSearch.apply(pageRequest);
    }

    protected List<String> getStatusNames(List<ContentStatus> statuses) {
        return statuses.stream().map(contentStatus -> ContentStatus.TRASHED.equals(contentStatus) ? "deleted" : contentStatus.getValue()).collect(Collectors.toList());
    }

    protected List<String> getContentStatusStringList(List<ContentStatus> statuses) {
        if (statuses.isEmpty()) {
            ArrayList<String> strContentStatus = new ArrayList<String>();
            strContentStatus.add(ContentStatus.CURRENT.getValue());
            return strContentStatus;
        }
        return this.getStatusNames(statuses);
    }

    protected List findNamedQueryStringParams(String queryName, HibernateObjectDao.Cacheability cacheability, LimitedRequest limitedRequest, Object ... paramNamesAndValues) {
        int offset = limitedRequest.getCursor() != null ? -1 : limitedRequest.getStart();
        int maxResultCount = limitedRequest.getLimit() + 1;
        return this.findNamedQueryStringParams(queryName, cacheability, offset, maxResultCount, paramNamesAndValues);
    }
}

