/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.hibernate;

import com.atlassian.bonnie.Indexer;
import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.persistence.hibernate.SessionFactoryWrapper;
import com.atlassian.confluence.impl.search.IndexerEventListener;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.exception.InfrastructureException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.NonUniqueResultException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.support.DaoSupport;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.orm.hibernate5.HibernateTemplate;
import org.springframework.orm.jpa.EntityManagerHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public abstract class HibernateObjectDao<T extends EntityObject>
extends DaoSupport {
    private static final Logger LOG = LoggerFactory.getLogger(HibernateObjectDao.class);
    private SessionFactory sessionFactory;

    protected abstract Class<T> getPersistentClass();

    public final SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public final void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Deprecated(forRemoval=true)
    public final HibernateTemplate getHibernateTemplate() {
        return this.createHibernateTemplate(this.sessionFactory);
    }

    protected HibernateOperations hibernate() {
        return HibernateOperations.wrap(this.getSessionFactory());
    }

    @Deprecated(forRemoval=true)
    public final void setHibernateTemplate(HibernateTemplate hibernateTemplate) {
    }

    @Deprecated(forRemoval=true)
    protected HibernateTemplate createHibernateTemplate(SessionFactory sessionFactory) {
        return new HibernateTemplate(sessionFactory);
    }

    protected @Nullable T getByClassId(long id) {
        return (T)this.hibernate().execute(session -> (EntityObject)session.get(this.getPersistentClass(), (Serializable)Long.valueOf(id)));
    }

    public @NonNull List<T> findAll() {
        return this.findAllSorted(null);
    }

    public @NonNull List<T> findAllSorted(String sortField) {
        return this.findAllSorted(sortField, true, -1, -1);
    }

    public @NonNull List<T> findAllSorted(String sortField, boolean cacheable, int offset, int maxResultCount) {
        String query = "FROM " + this.getPersistentClass().getName() + " result";
        if (sortField != null) {
            query = query + " ORDER BY LOWER(result." + sortField + ")";
        }
        String finalQuery = query;
        List result = this.hibernate().execute(session -> {
            Query queryObject = session.createQuery(finalQuery, this.getPersistentClass());
            queryObject.setCacheable(cacheable);
            HibernateObjectDao.applyTransactionTimeout(queryObject, this.getSessionFactory());
            this.limitQuery(queryObject, offset, maxResultCount);
            return queryObject.list();
        });
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public void save(T objectToSave) {
        this.updateModificationData(objectToSave);
        this.saveRaw(objectToSave);
    }

    @Deprecated(forRemoval=true)
    public final void saveEntity(T objectToSave) {
        this.save(objectToSave);
    }

    protected void updateModificationData(T objectToSave) {
        Date date = objectToSave.getCurrentDate();
        objectToSave.setLastModificationDate(date);
        if (objectToSave.getCreationDate() == null) {
            objectToSave.setCreationDate(date);
        }
    }

    protected void saveRaw(T objectToSave) {
        this.hibernate().saveOrUpdate(objectToSave);
        this.reIndex((EntityObject)objectToSave);
    }

    protected void remove(T objectToRemove) {
        try {
            this.hibernate().delete(objectToRemove);
        }
        catch (Exception e) {
            LOG.error("remove error!", (Throwable)e);
            throw new InfrastructureException((Throwable)e);
        }
    }

    private void withIndexer(Consumer<Indexer> task) {
        this.publishEvent((indexer, changeIndexer) -> task.accept(indexer));
    }

    protected void publishEvent(IndexerEventListener.VisitorEvent event) {
    }

    protected void reIndex(EntityObject objectToSave) {
        this.withIndexer(indexer -> HibernateObjectDao.reIndex(objectToSave, indexer));
    }

    private static void reIndex(EntityObject objectToSave, Indexer indexer) {
        if (objectToSave instanceof Searchable) {
            HibernateObjectDao.reIndex((Searchable)objectToSave, indexer);
        }
    }

    private static void reIndex(Searchable objectToSave, Indexer indexer) {
        try {
            indexer.reIndex(objectToSave);
        }
        catch (RuntimeException e) {
            LOG.error("Unable to reIndex object: {} -- {}", new Object[]{objectToSave, e.getMessage(), e});
        }
    }

    @Deprecated
    protected List findNamedQuery(String queryName) {
        return this.findNamedQueryStringParams(queryName, Cacheability.CACHEABLE, -1, -1, new Object[0]);
    }

    protected List findNamedQuery(String queryName, Cacheability cacheability) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, -1, new Object[0]);
    }

    protected List findNamedQuery(String queryName, Cacheability cacheability, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, maxResultCount, new Object[0]);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue) {
        return this.findNamedQueryStringParams(queryName, Cacheability.CACHEABLE, -1, -1, paramName, paramValue);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue, Cacheability cacheability) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, -1, paramName, paramValue);
    }

    protected List findNamedQueryStringParam(String queryName, String paramName, Object paramValue, Cacheability cacheability, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, maxResultCount, paramName, paramValue);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value) {
        return this.findNamedQueryStringParams(queryName, Cacheability.CACHEABLE, -1, -1, paramName, paramValue, param2Name, param2Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, Cacheability cacheability) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, -1, paramName, paramValue, param2Name, param2Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, Cacheability cacheability, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, maxResultCount, paramName, paramValue, param2Name, param2Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value) {
        return this.findNamedQueryStringParams(queryName, Cacheability.CACHEABLE, -1, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, Cacheability cacheability) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, Cacheability cacheability, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, maxResultCount, paramName, paramValue, param2Name, param2Value, param3Name, param3Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value) {
        return this.findNamedQueryStringParams(queryName, Cacheability.CACHEABLE, -1, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value, Cacheability cacheability) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, -1, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    protected List findNamedQueryStringParams(String queryName, String paramName, Object paramValue, String param2Name, Object param2Value, String param3Name, Object param3Value, String param4Name, Object param4Value, Cacheability cacheability, int maxResultCount) {
        return this.findNamedQueryStringParams(queryName, cacheability, -1, maxResultCount, paramName, paramValue, param2Name, param2Value, param3Name, param3Value, param4Name, param4Value);
    }

    @Deprecated
    protected List findNamedQueryStringParams(String queryName, boolean cacheable, int offset, int maxResultCount, Object ... paramNamesAndValues) {
        return this.findNamedQueryStringParams(queryName, Cacheability.fromBoolean(cacheable), offset, maxResultCount, paramNamesAndValues);
    }

    protected List findNamedQueryStringParams(String queryName, Cacheability cacheability, int offset, int maxResultCount, Object ... paramNamesAndValues) {
        if (paramNamesAndValues.length % 2 == 1) {
            throw new IllegalArgumentException("There must be an even number of parameter names and values.");
        }
        Session session = this.getSessionFactory().getCurrentSession();
        Query queryObject = session.getNamedQuery(queryName);
        queryObject.setCacheable(cacheability == Cacheability.CACHEABLE);
        HibernateObjectDao.applyTransactionTimeout(queryObject, this.getSessionFactory());
        for (int i = 0; i < paramNamesAndValues.length; i += 2) {
            String paramName = (String)paramNamesAndValues[i];
            if (paramName == null) {
                throw new IllegalArgumentException("Parameter names cannot be null.");
            }
            Object paramValue = paramNamesAndValues[i + 1];
            if (paramValue instanceof Collection) {
                Collection collection = (Collection)paramValue;
                if (collection.isEmpty()) {
                    throw new IllegalArgumentException("Encountered empty collection for parameter: " + paramName + ". Hibernate does not support empty brackets after the sql 'in' clause.");
                }
                queryObject.setParameterList(paramName, collection);
                continue;
            }
            queryObject.setParameter(paramName, paramValue);
        }
        this.limitQuery(queryObject, offset, maxResultCount);
        return queryObject.list();
    }

    private void limitQuery(Query queryObject, int offset, int maxResultCount) {
        if (offset != -1) {
            queryObject.setFirstResult(offset);
        }
        if (maxResultCount != -1) {
            queryObject.setMaxResults(maxResultCount);
        }
    }

    @Deprecated
    protected int getCountResult(@Nullable List<Number> results) {
        return DataAccessUtils.intResult(results);
    }

    @Deprecated
    protected <T extends EntityObject> @Nullable T findSingleObject(List<T> results) {
        if (results == null || results.isEmpty()) {
            return null;
        }
        EntityObject result = (EntityObject)results.get(0);
        if (results.size() != 1) {
            LOG.error("Uh oh - found more than one object when single object requested: {}", results);
            for (EntityObject entity : results) {
                if (entity.getId() >= result.getId()) continue;
                result = entity;
            }
        }
        return (T)result;
    }

    protected <E> E uniqueResult(List<E> results) throws NonUniqueResultException {
        if (results == null || results.isEmpty()) {
            return null;
        }
        Iterator<E> iterator = results.iterator();
        E firstResult = iterator.next();
        while (iterator.hasNext()) {
            E nextResult = iterator.next();
            if (firstResult == nextResult) continue;
            throw new NonUniqueResultException(results.size());
        }
        return firstResult;
    }

    protected final void checkDaoConfig() {
        if (this.sessionFactory == null) {
            throw new IllegalArgumentException("'sessionFactory' is required");
        }
    }

    protected static void applyTransactionTimeout(Query query, SessionFactory sessionFactory) {
        Integer timeout = HibernateObjectDao.getTransactionTimeout(sessionFactory);
        if (timeout != null) {
            query.setTimeout(timeout.intValue());
        }
    }

    private static Integer getTransactionTimeout(SessionFactory sessionFactory) {
        EntityManagerHolder entityManagerHolder;
        if (TransactionSynchronizationManager.hasResource((Object)sessionFactory) && (entityManagerHolder = (EntityManagerHolder)TransactionSynchronizationManager.getResource((Object)sessionFactory)) != null && entityManagerHolder.hasTimeout()) {
            return entityManagerHolder.getTimeToLiveInSeconds();
        }
        return null;
    }

    protected static sealed interface HibernateOperations
    permits SessionFactoryWrapper {
        public <T> T execute(Function<Session, T> var1);

        public void saveOrUpdate(Object var1);

        public void delete(Object var1);

        public <T> T get(Class<T> var1, Serializable var2);

        public Iterator<?> iterate(String var1);

        public List<?> find(String var1);

        public void flush();

        public void update(Object var1);

        public void save(Object var1);

        public void evict(Object var1);

        public static HibernateOperations wrap(SessionFactory sessionFactory) {
            return new SessionFactoryWrapper(Objects.requireNonNull(sessionFactory));
        }
    }

    public static enum Cacheability {
        CACHEABLE,
        NOT_CACHEABLE;


        public static Cacheability fromBoolean(boolean flag) {
            return flag ? CACHEABLE : NOT_CACHEABLE;
        }
    }
}

