/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.hibernate;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.core.SpaceContentEntityObject;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.core.persistence.SearchableDao;
import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.HibernateHandle;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.pages.Comment;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.core.exception.InfrastructureException;
import jakarta.persistence.PersistenceException;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.spi.MetamodelImplementor;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class HibernateSearchableDao
implements SearchableDao {
    private static final Logger log = LoggerFactory.getLogger(HibernateSearchableDao.class);
    private final SessionFactoryImplementor sessionFactory;

    HibernateSearchableDao(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Deprecated(forRemoval=true)
    public HibernateSearchableDao(SessionFactory sessionFactory) {
        this((SessionFactoryImplementor)sessionFactory);
    }

    @Override
    public List<List<HibernateHandle>> getLatestSearchableHandlesGroupedByType() {
        return this.getLatestSearchableHandlesGroupedByType(Optional.empty());
    }

    @Override
    @Transactional(readOnly=true)
    public List<List<HibernateHandle>> getLatestSearchableHandlesGroupedByType(Optional<String> spaceKey) {
        Collection<Class<? extends Searchable>> implementingClasses = this.getClassesImplementingSearchable();
        LinkedList<List<HibernateHandle>> result = new LinkedList<List<HibernateHandle>>();
        for (Class<? extends Searchable> clazz : implementingClasses) {
            List<HibernateHandle> handles = this.getLatestSearchableHandles(clazz, spaceKey);
            if (handles.isEmpty()) continue;
            result.add(handles);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public List<HibernateHandle> getLatestSearchableHandles(Class<? extends Searchable> clazz) {
        return this.getLatestSearchableHandles(clazz, Optional.empty());
    }

    @Override
    @Transactional(readOnly=true)
    public List<HibernateHandle> getLatestSearchableHandles(Class<? extends Searchable> clazz, Optional<String> spaceKeyOptional) {
        if (spaceKeyOptional.isPresent() && !this.isSpaceContentEntitySubClassOrComment(clazz)) {
            return Collections.emptyList();
        }
        try (Cleanup ignored = SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.IGNORE);){
            Collection implementingClasses;
            if (Comment.class.isAssignableFrom(clazz)) {
                Session session = this.sessionFactory.getCurrentSession();
                Query query = session.createQuery(this.getHqlCommentQuery(clazz, spaceKeyOptional), Long.class);
                spaceKeyOptional.ifPresent(spaceKey -> query.setParameter("spaceKey", spaceKey));
                List<HibernateHandle> list = this.findHandles((Query<Long>)query, clazz);
                return list;
            }
            Collection collection = spaceKeyOptional.isPresent() ? (Collection)this.getClassesImplementingSearchable().stream().filter(SpaceContentEntityObject.class::isAssignableFrom).collect(Collectors.toList()) : (implementingClasses = this.getClassesImplementingSearchable());
            if (!implementingClasses.contains(clazz)) {
                throw new IllegalArgumentException(String.valueOf(clazz) + " is not a hibernate entity class");
            }
            Session session = this.sessionFactory.getCurrentSession();
            Query query = session.createQuery(this.getHqlQuery(clazz, spaceKeyOptional), Long.class);
            spaceKeyOptional.ifPresent(spaceKey -> query.setParameter("spaceKey", spaceKey));
            List<HibernateHandle> list = this.findHandles((Query<Long>)query, clazz);
            return list;
        }
    }

    private boolean isSpaceContentEntitySubClassOrComment(Class<? extends Searchable> clazz) {
        return SpaceContentEntityObject.class.isAssignableFrom(clazz) || Comment.class.isAssignableFrom(clazz);
    }

    private List<HibernateHandle> findHandles(Query<Long> query, Class<? extends Searchable> clazz) {
        query.setCacheable(false);
        List ids = query.list();
        LinkedList<HibernateHandle> result = new LinkedList<HibernateHandle>();
        for (Long id : ids) {
            result.add(new HibernateHandle(clazz.getName(), id.longValue()));
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public int getCountOfLatestSearchables() {
        Collection<Class<? extends Searchable>> implementingClasses = this.getClassesImplementingSearchable();
        Session session = this.sessionFactory.getCurrentSession();
        int result = 0;
        for (Class<? extends Searchable> clazz : implementingClasses) {
            result += ((Number)session.createQuery(this.getHqlCountQuery(clazz, Optional.empty()), Number.class).uniqueResult()).intValue();
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public int getCountOfLatestSearchables(String spaceKey) {
        List<Class> implementingClasses = this.getClassesImplementingSearchable().stream().filter(SpaceContentEntityObject.class::isAssignableFrom).toList();
        Session session = this.sessionFactory.getCurrentSession();
        int result = 0;
        for (Class clazz : implementingClasses) {
            result += ((Number)session.createQuery(this.getHqlCountQuery(clazz, Optional.ofNullable(spaceKey)), Number.class).setParameter("spaceKey", (Object)spaceKey).uniqueResult()).intValue();
        }
        int count = result;
        return count += ((Number)session.createQuery(this.getHqlCommentCountQuery(Comment.class, Optional.ofNullable(spaceKey)), Number.class).setParameter("spaceKey", (Object)spaceKey).uniqueResult()).intValue();
    }

    @Override
    @Transactional(readOnly=true)
    public int getCountOfLatestSearchables(Class<? extends Searchable> clazz) {
        Collection<Class<? extends Searchable>> implementingClasses = this.getClassesImplementingSearchable();
        if (!implementingClasses.contains(clazz)) {
            throw new IllegalArgumentException(String.valueOf(clazz) + " is not a hibernate entity class");
        }
        Session session = this.sessionFactory.getCurrentSession();
        return ((Number)session.createQuery(this.getHqlCountQuery(clazz, Optional.empty()), Number.class).uniqueResult()).intValue();
    }

    @Override
    public int getCountOfLatestSearchables(String spaceKey, Class<? extends Searchable> clazz) {
        if (Comment.class.isAssignableFrom(clazz)) {
            Session session = this.sessionFactory.getCurrentSession();
            return ((Number)session.createQuery(this.getHqlCommentCountQuery(clazz, Optional.ofNullable(spaceKey)), Number.class).setParameter("spaceKey", (Object)spaceKey).uniqueResult()).intValue();
        }
        if (!SpaceContentEntityObject.class.isAssignableFrom(clazz)) {
            return 0;
        }
        List<Class> implementingClasses = this.getClassesImplementingSearchable().stream().filter(SpaceContentEntityObject.class::isAssignableFrom).toList();
        if (!implementingClasses.contains(clazz)) {
            throw new IllegalArgumentException(String.valueOf(clazz) + " is not a hibernate entity class");
        }
        Session session = this.sessionFactory.getCurrentSession();
        return ((Number)session.createQuery(this.getHqlCountQuery(clazz, Optional.ofNullable(spaceKey)), Number.class).setParameter("spaceKey", (Object)spaceKey).uniqueResult()).intValue();
    }

    private String getHqlQuery(Class<?> clazz, Optional<String> spaceKeyOptional) {
        StringBuilder query = new StringBuilder();
        if (Versioned.class.isAssignableFrom(clazz)) {
            query.append(String.format("select searchable.id from %s searchable where searchable.originalVersion is null", clazz.getName()));
            spaceKeyOptional.ifPresent(spaceKey -> query.append(" and searchable.space.key = :spaceKey"));
        } else {
            query.append(String.format("select searchable.id from %s searchable", clazz.getName()));
            spaceKeyOptional.ifPresent(spaceKey -> query.append(" where searchable.space.key = :spaceKey"));
        }
        return query.toString();
    }

    private String getHqlCommentQuery(Class<?> clazz, Optional<String> spaceKeyOptional) {
        StringBuilder query = new StringBuilder();
        if (Versioned.class.isAssignableFrom(clazz)) {
            query.append(String.format("select comment.id from %s comment where comment.originalVersion is null", clazz.getName()));
            spaceKeyOptional.ifPresent(spaceKey -> query.append(" and comment.containerContent.space.key = :spaceKey"));
        } else {
            query.append(String.format("select comment.id from %s comment", clazz.getName()));
            spaceKeyOptional.ifPresent(spaceKey -> query.append(" where comment.containerContent.space.key = :spaceKey"));
        }
        return query.toString();
    }

    private String getHqlCommentCountQuery(Class<?> clazz, Optional<String> spaceKeyOptional) {
        StringBuilder query = new StringBuilder();
        if (Versioned.class.isAssignableFrom(clazz)) {
            query.append(String.format("select count(*) from %s comment where comment.originalVersion is null", clazz.getName()));
            spaceKeyOptional.ifPresent(spaceKey -> query.append(" and comment.containerContent.space.key = :spaceKey"));
        } else {
            query.append(String.format("select count(*) from %s comment", clazz.getName()));
            spaceKeyOptional.ifPresent(spaceKey -> query.append(" where comment.containerContent.space.key =  :spaceKey"));
        }
        return query.toString();
    }

    private String getHqlCountQuery(Class<?> clazz, Optional<String> spaceKeyOptional) {
        StringBuilder query = new StringBuilder();
        if (Versioned.class.isAssignableFrom(clazz)) {
            query.append(String.format("select count(*) from %s searchable where searchable.originalVersion is null", clazz.getName()));
            spaceKeyOptional.ifPresent(spaceKey -> query.append(" and searchable.space.key = :spaceKey"));
        } else {
            query.append(String.format("select count(*) from %s searchable", clazz.getName()));
            spaceKeyOptional.ifPresent(spaceKey -> query.append(" where searchable.space.key =  :spaceKey"));
        }
        return query.toString();
    }

    private Collection<Class<? extends Searchable>> getClassesImplementingSearchable() {
        LinkedHashSet<Class<? extends Searchable>> implementingClasses = new LinkedHashSet<Class<? extends Searchable>>();
        try {
            MetamodelImplementor metamodel = this.sessionFactory.getMetamodel();
            for (String entityName : metamodel.getAllEntityNames()) {
                Class clazz = metamodel.entityPersister(entityName).getMappedClass();
                if (!Searchable.class.isAssignableFrom(clazz) || !HibernateSearchableDao.isConcrete(clazz)) continue;
                implementingClasses.add(clazz.asSubclass(Searchable.class));
            }
        }
        catch (PersistenceException e) {
            throw new InfrastructureException("Unable to determine classes implementing Searchable");
        }
        log.debug("Classes implementing Searchable: {}", implementingClasses);
        return implementingClasses;
    }

    private static boolean isConcrete(Class<?> clazz) {
        return !Modifier.isAbstract(clazz.getModifiers());
    }
}

