/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.hibernate;

import com.atlassian.confluence.core.persistence.hibernate.HibernateObjectDao;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import org.hibernate.Session;
import org.hibernate.SessionFactory;

record SessionFactoryWrapper(SessionFactory sessionFactory) implements HibernateObjectDao.HibernateOperations
{
    public <I> I execute(Function<Session, I> callback) {
        return callback.apply(this.session());
    }

    @Override
    public void saveOrUpdate(Object objectToSave) {
        this.session().saveOrUpdate(objectToSave);
    }

    @Override
    public void delete(Object objectToRemove) {
        this.session().delete(objectToRemove);
    }

    public <I> I get(Class<I> type, Serializable id) {
        return (I)this.session().get(type, id);
    }

    @Override
    public Iterator<?> iterate(String query) {
        return this.session().createQuery(query).iterate();
    }

    @Override
    public List<?> find(String query) {
        return this.session().createQuery(query).list();
    }

    @Override
    public void flush() {
        this.session().flush();
    }

    @Override
    public void update(Object object) {
        this.session().update(object);
    }

    @Override
    public void save(Object object) {
        this.session().save(object);
    }

    @Override
    public void evict(Object object) {
        this.session().evict(object);
    }

    private Session session() {
        return this.sessionFactory.getCurrentSession();
    }
}

