/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.hibernate;

import com.atlassian.bonnie.Searchable;
import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.core.ConfluenceEntityObject;
import com.atlassian.confluence.core.Versioned;
import com.atlassian.confluence.core.persistence.confluence.StaleObjectStateException;
import com.atlassian.confluence.core.persistence.hibernate.ConfluenceHibernateObjectDao;
import com.atlassian.confluence.core.persistence.hibernate.HibernateObjectDao;
import com.atlassian.core.bean.EntityObject;
import com.atlassian.core.exception.InfrastructureException;
import jakarta.persistence.OptimisticLockException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.StaleStateException;
import org.hibernate.query.Query;

public abstract class VersionedHibernateObjectDao<T extends ConfluenceEntityObject>
extends ConfluenceHibernateObjectDao<T> {
    private String generateFindAllQueryString(String sortField, String ... statuses) {
        StringBuilder sb = new StringBuilder();
        sb.append("FROM ").append(this.getPersistentClass().getName()).append(" result");
        if (Versioned.class.isAssignableFrom(this.getPersistentClass())) {
            sb.append(" WHERE result.originalVersion is null");
            if (ConfluenceEntityObject.class.isAssignableFrom(this.getPersistentClass())) {
                sb.append(" AND result.contentStatus in (");
                boolean isFirst = true;
                for (String status : statuses) {
                    if (isFirst) {
                        isFirst = false;
                    } else {
                        sb.append(',');
                    }
                    sb.append('\'').append(status).append('\'');
                }
                sb.append(')');
            }
        }
        if (sortField != null) {
            sb.append(" ORDER BY LOWER(result.").append(sortField).append(')');
        }
        return sb.toString();
    }

    public Iterator<T> findLatestVersionsIterator() {
        return this.findLatestVersionsIterator("current");
    }

    protected Iterator<T> findLatestVersionsIterator(String ... statuses) {
        return this.hibernate().iterate(this.generateFindAllQueryString(null, statuses));
    }

    protected long findLatestVersionsCount(String ... statuses) {
        String originalQueryString = "SELECT COUNT(*) " + this.generateFindAllQueryString(null, statuses);
        List<?> resultsList = this.hibernate().find(originalQueryString);
        if (resultsList.isEmpty()) {
            return 0L;
        }
        Number number = (Number)resultsList.get(0);
        return number.longValue();
    }

    @Override
    public @NonNull List<T> findAllSorted(String sortField) {
        String finalQuery = this.generateFindAllQueryString(sortField, "current");
        List result = this.hibernate().execute(session -> {
            Query queryObject = session.createQuery(finalQuery, this.getPersistentClass());
            queryObject.setCacheable(true);
            VersionedHibernateObjectDao.applyTransactionTimeout(queryObject, this.getSessionFactory());
            return queryObject.list();
        });
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public final void save(T objectToSave, @Nullable T previousVersion) {
        this.updateModificationData(objectToSave);
        if (previousVersion != null) {
            if (((Versioned)objectToSave).getVersion() > ((Versioned)previousVersion).getVersion()) {
                throw new StaleObjectStateException("The version of the object to be saved was more than the previous version!");
            }
            ((Versioned)previousVersion).convertToHistoricalVersion();
            ((Versioned)previousVersion).setOriginalVersion((Versioned)objectToSave);
            this.applyChildVersioningPolicy((Versioned)previousVersion, (Versioned)objectToSave);
            this.hibernate().saveOrUpdate(previousVersion);
            ((Versioned)objectToSave).setVersion(((Versioned)objectToSave).getVersion() + 1);
        }
        this.hibernate().saveOrUpdate(objectToSave);
        try {
            this.hibernate().flush();
        }
        catch (OptimisticLockException | StaleStateException e) {
            throw new StaleObjectStateException(e);
        }
        if (previousVersion != null) {
            this.reIndex((EntityObject)previousVersion);
            this.reIndex((EntityObject)objectToSave);
        } else {
            this.index(objectToSave);
        }
    }

    protected void applyChildVersioningPolicy(Versioned previousVersioned, Versioned updatedVersioned) {
        previousVersioned.applyChildVersioningPolicy(updatedVersioned, this::removeAndUnindex);
    }

    private void index(T entity) {
        if (entity instanceof Searchable) {
            Searchable searchable = (Searchable)entity;
            this.publishEvent((indexer, changeIndexer) -> indexer.index(searchable));
        }
    }

    private void removeAndUnindex(Versioned objectToRemove) {
        try {
            this.hibernate().delete(objectToRemove);
            if (objectToRemove instanceof Searchable) {
                Searchable searchable = (Searchable)objectToRemove;
                this.unIndex(searchable);
            }
        }
        catch (Exception e) {
            throw new InfrastructureException((Throwable)e);
        }
    }

    @Override
    protected void remove(T entity) {
        this.removeAndUnindex((Versioned)entity);
    }

    private void unIndex(Searchable entity) {
        this.publishEvent((indexer, changeIndexer) -> indexer.unIndexIncludingDependents(entity));
    }

    @Deprecated
    protected List findNamedQueryStringParams(String queryName, boolean cacheable, LimitedRequest limitedRequest, Object ... paramNamesAndValues) {
        return this.findNamedQueryStringParams(queryName, HibernateObjectDao.Cacheability.fromBoolean(cacheable), limitedRequest, paramNamesAndValues);
    }
}

