/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.core.persistence.schema;

import com.atlassian.confluence.core.persistence.VersionHistoryDao;
import com.atlassian.confluence.core.persistence.schema.api.SchemaComparison;
import com.atlassian.confluence.core.persistence.schema.api.SchemaComparisonService;
import com.atlassian.confluence.core.persistence.schema.event.SchemaInconsistencyWarningEvent;
import com.atlassian.confluence.setup.BuildInformation;
import com.atlassian.event.api.EventPublisher;
import jakarta.annotation.PostConstruct;
import java.util.Collection;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StartupSchemaChecker {
    private static final Logger log = LoggerFactory.getLogger(StartupSchemaChecker.class);
    private final SchemaComparisonService schemaComparisonService;
    private final EventPublisher eventPublisher;
    private final VersionHistoryDao versionHistoryDao;

    StartupSchemaChecker(SchemaComparisonService schemaComparisonService, EventPublisher eventPublisher, VersionHistoryDao versionHistoryDao) {
        this.versionHistoryDao = Objects.requireNonNull(versionHistoryDao);
        this.schemaComparisonService = Objects.requireNonNull(schemaComparisonService);
        this.eventPublisher = Objects.requireNonNull(eventPublisher);
    }

    @PostConstruct
    void checkSchemaIfBuildNumbersMatch() {
        if (this.doDatabaseAndAppBuildNumbersMatch()) {
            this.checkSchema();
        } else {
            log.debug("Database build number {} doesn't match application build number {}, so no meaningful schema comparison can be performed", (Object)this.versionHistoryDao.getLatestBuildNumber(), (Object)BuildInformation.INSTANCE.getBuildNumber());
        }
    }

    private void checkSchema() {
        log.debug("Verifying consistency between expected and actual database schemata");
        try {
            SchemaComparison schemaComparison = this.schemaComparisonService.compareExpectedWithActualSchema();
            this.handleWarnings(schemaComparison.getWarnings());
        }
        catch (Exception ex) {
            log.error("Failed to verify schema consistency", (Throwable)ex);
        }
    }

    private boolean doDatabaseAndAppBuildNumbersMatch() {
        String databaseBuildNumber = String.valueOf(this.versionHistoryDao.getLatestBuildNumber());
        return Objects.equals(BuildInformation.INSTANCE.getBuildNumber(), databaseBuildNumber);
    }

    private void handleWarnings(Collection<String> warnings) {
        if (warnings.isEmpty()) {
            log.info("Database schema consistency checks out OK");
        } else {
            log.warn("Database schema is inconsistent with expectations. {} potential issues found, see below for details.", (Object)warnings.size());
            for (String warning : warnings) {
                log.warn(warning);
            }
            this.eventPublisher.publish((Object)new SchemaInconsistencyWarningEvent(warnings.size()));
        }
    }
}

