/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.diff;

import com.atlassian.confluence.diff.DiffPostProcessor;
import com.atlassian.confluence.macro.browser.MacroIconManager;
import com.atlassian.confluence.macro.browser.MacroMetadataManager;
import com.atlassian.confluence.macro.browser.beans.MacroMetadata;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.i18n.I18NBeanFactory;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Text;
import org.jdom2.filter.Filters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MacroIconInsertingPostProcessor
implements DiffPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(MacroIconInsertingPostProcessor.class);
    private final MacroMetadataManager macroMetadataManager;
    private final MacroIconManager macroIconManager;
    private final I18NBeanFactory i18NBeanFactory;

    public MacroIconInsertingPostProcessor(MacroMetadataManager macroMetadataManager, MacroIconManager macroIconManager, I18NBeanFactory i18NBeanFactory) {
        this.macroMetadataManager = macroMetadataManager;
        this.macroIconManager = macroIconManager;
        this.i18NBeanFactory = i18NBeanFactory;
    }

    @Override
    public Document process(Document document) {
        List<Element> macroElements = this.findMacroHeaderElements(document);
        this.processMacroHeaderElements(macroElements, this.i18NBeanFactory.getI18NBean());
        return document;
    }

    private void processMacroHeaderElements(List<Element> macroElements, I18NBean i18NBean) {
        for (Element element : macroElements) {
            String macroName = element.getText();
            MacroMetadata macroMetadata = this.macroMetadataManager.getMacroMetadataByName(macroName);
            if (macroMetadata == null) {
                log.warn("Could not find macro with name '{}'", (Object)macroName);
                continue;
            }
            element.setText(this.localiseMacroTitle(macroMetadata, i18NBean));
            Element icon = new Element("span");
            icon.setText(" ");
            this.addOrSetClassAttribute(icon, "icon macro-placeholder-icon");
            String iconUrl = this.getMacroIconUrl(macroMetadata);
            String backgroundImageStyle = "background-image: url(" + iconUrl + ");";
            this.addOrSetStyle(icon, backgroundImageStyle);
            element.addContent(0, (Content)icon);
        }
    }

    private void addOrSetStyle(Element element, String style) {
        Attribute styleAttribute = element.getAttribute("style");
        if (styleAttribute == null || StringUtils.isEmpty((CharSequence)styleAttribute.getValue())) {
            styleAttribute = new Attribute("style", style);
            element.setAttribute(styleAttribute);
        } else {
            styleAttribute.setValue(styleAttribute.getValue() + "; " + style);
        }
    }

    private void addOrSetClassAttribute(Element element, String value) {
        Attribute classAttribute = element.getAttribute("class");
        if (classAttribute == null || StringUtils.isEmpty((CharSequence)classAttribute.getValue())) {
            classAttribute = new Attribute("class", value);
            element.setAttribute(classAttribute);
        } else {
            classAttribute.setValue(classAttribute.getValue() + " " + value);
        }
    }

    private String getMacroIconUrl(MacroMetadata macroMetadata) {
        return this.macroIconManager.getExternalSmallIconUrl(macroMetadata);
    }

    private List<Element> findMacroHeaderElements(Document document) {
        ArrayList<Element> macroElements = new ArrayList<Element>();
        for (Element element : document.getRootElement().getDescendants(Filters.element((String)"th"))) {
            Element e;
            Attribute classAttribute = element.getAttribute("class");
            if (classAttribute == null || classAttribute.getValue() == null || !classAttribute.getValue().contains("diff-macro-title") || (e = this.skipDiffSpans(element)) == null) continue;
            macroElements.add(e);
        }
        return macroElements;
    }

    private Element skipDiffSpans(Element element) {
        List contents = element.getContent();
        if (contents.isEmpty()) {
            return element;
        }
        Content first = (Content)contents.get(0);
        if (first instanceof Text) {
            return element;
        }
        if (first instanceof Element) {
            return this.skipDiffSpans((Element)first);
        }
        return element;
    }

    private String localiseMacroTitle(MacroMetadata metadata, I18NBean i18NBean) {
        String title = i18NBean.getText(metadata.getTitle());
        if (title == null || title.equals(metadata.getTitle().getKey())) {
            return StringUtils.capitalize((String)metadata.getMacroName()).replace('-', ' ');
        }
        return title;
    }
}

