/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.diff;

import com.atlassian.confluence.api.model.content.id.ContentId;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.diff.DaisyHtmlDiffer;
import com.atlassian.confluence.diff.Differ;
import com.atlassian.confluence.xhtml.api.WikiToStorageConverter;
import com.google.common.base.Throwables;
import io.atlassian.util.concurrent.ConcurrentOperationMap;
import io.atlassian.util.concurrent.ConcurrentOperationMapImpl;
import java.util.concurrent.ExecutionException;

public class WikiConvertingHtmlDiffer
implements Differ {
    private final ConcurrentOperationMap<Pair, String> operationMap = new ConcurrentOperationMapImpl();
    private final WikiToStorageConverter wikiToStorageConverter;
    private final DaisyHtmlDiffer delegateDiffer;

    public WikiConvertingHtmlDiffer(WikiToStorageConverter wikiToStorageConverter, DaisyHtmlDiffer delegateDiffer) {
        this.wikiToStorageConverter = wikiToStorageConverter;
        this.delegateDiffer = delegateDiffer;
    }

    @Override
    public String diff(ContentEntityObject left, ContentEntityObject right) {
        try {
            return (String)this.operationMap.runOperation((Object)new Pair(left, right), () -> this.diffInternal(left, right));
        }
        catch (ExecutionException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }

    private String diffInternal(ContentEntityObject left, ContentEntityObject right) {
        return this.delegateDiffer.diff(this.wikiToStorageConverter.convertWikiBodyToStorage(left), this.wikiToStorageConverter.convertWikiBodyToStorage(right));
    }

    record Pair(ContentId leftId, ContentId rightId) {
        Pair(ContentEntityObject left, ContentEntityObject right) {
            this(left.getContentId(), right.getContentId());
        }
    }
}

