/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.diff;

import com.atlassian.confluence.diff.DiffPostProcessor;
import com.atlassian.core.util.ClassLoaderUtils;
import java.io.IOException;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamSource;
import org.jdom2.Document;
import org.jdom2.transform.JDOMResult;
import org.jdom2.transform.JDOMSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XSLDiffPostProcessor
implements DiffPostProcessor {
    private static volatile TransformerFactory transformerFactory;
    private static final Logger log;
    private static final String XSLT_SECURE_PROCESSING_ENABLED_KEY = "confluence.xslt.secure.processing.enabled";
    private final URL styleSheetResource;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static TransformerFactory createTransformerFactory() {
        if (transformerFactory != null) return transformerFactory;
        Class<XSLDiffPostProcessor> clazz = XSLDiffPostProcessor.class;
        synchronized (XSLDiffPostProcessor.class) {
            if (transformerFactory != null) return transformerFactory;
            TransformerFactory factory = TransformerFactory.newInstance();
            if (XSLDiffPostProcessor.isSecureProcessingEnabled()) {
                try {
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (TransformerException ex) {
                    throw new IllegalStateException("Failed to enable secure processing for TransformerFactory", ex);
                }
            }
            transformerFactory = factory;
            // ** MonitorExit[var0] (shouldn't be in output)
            return transformerFactory;
        }
    }

    public XSLDiffPostProcessor(String styleSheetResource) {
        this.styleSheetResource = ClassLoaderUtils.getResource((String)styleSheetResource, XSLDiffPostProcessor.class);
        if (this.styleSheetResource == null) {
            throw new IllegalArgumentException("The styleSheetResource " + styleSheetResource + " could not be opened.");
        }
    }

    @Override
    public Document process(Document document) {
        log.debug("Starting the XSLDiffPostProcessor with the stylesheet {}.", (Object)this.styleSheetResource.getFile());
        try {
            JDOMSource docSource = new JDOMSource(document);
            StreamSource transXsltSource = new StreamSource(this.styleSheetResource.openStream());
            JDOMResult result = new JDOMResult();
            TransformerFactory factory = XSLDiffPostProcessor.createTransformerFactory();
            Transformer transformer = factory.newTransformer(transXsltSource);
            transformer.transform((Source)docSource, (Result)result);
            return result.getDocument();
        }
        catch (IOException ex) {
            log.warn("An Exception occurred while reading the stylesheet resource {}. The XSLDiffPostProcessor has not been applied.", (Object)this.styleSheetResource.getFile(), (Object)ex);
        }
        catch (TransformerException ex) {
            log.warn("An Exception occurred while trying to create the transformer to apply the XSL {}. The XSLDiffPostProcessor has not been applied.", (Object)this.styleSheetResource.getFile(), (Object)ex);
        }
        log.debug("Finished the XSLDiffPostProcessor with the stylesheet {}.", (Object)this.styleSheetResource.getFile());
        return document;
    }

    private static boolean isSecureProcessingEnabled() {
        String defaultValue = "true";
        return Boolean.parseBoolean(System.getProperty(XSLT_SECURE_PROCESSING_ENABLED_KEY, "true"));
    }

    static {
        log = LoggerFactory.getLogger(XSLDiffPostProcessor.class);
    }
}

