/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.dmz.json;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConfluenceJsonFilter
extends SimpleBeanPropertyFilter {
    public static final String CONFLUENCE_JSON_FILTER = "ConfluenceJsonFilter";

    protected boolean include(PropertyWriter writer) {
        Class propertyClass = writer.getType().getRawClass();
        if (propertyClass.isArray()) {
            Class<?> componentType = propertyClass.getComponentType();
            return ConfluenceJsonFilter.isAllowed(componentType);
        }
        if (List.class.isAssignableFrom(propertyClass)) {
            Class elementType = ((JavaType)writer.getType().getBindings().getTypeParameters().getFirst()).getRawClass();
            return ConfluenceJsonFilter.isAllowed(elementType);
        }
        if (Properties.class.isAssignableFrom(propertyClass)) {
            Class keyType = writer.getType().getKeyType().getRawClass();
            Class valueType = writer.getType().getContentType().getRawClass();
            return ConfluenceJsonFilter.isAllowed(keyType) && ConfluenceJsonFilter.isAllowed(valueType);
        }
        if (Map.class.isAssignableFrom(propertyClass)) {
            Class keyType = ((JavaType)writer.getType().getBindings().getTypeParameters().getFirst()).getRawClass();
            Class valueType = ((JavaType)writer.getType().getBindings().getTypeParameters().get(1)).getRawClass();
            return ConfluenceJsonFilter.isAllowed(keyType) && ConfluenceJsonFilter.isAllowed(valueType);
        }
        return ConfluenceJsonFilter.isAllowed(propertyClass);
    }

    private static boolean isAllowed(Class<?> componentType) {
        return componentType.isPrimitive() || Serializable.class.isAssignableFrom(componentType);
    }
}

