/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.dmz.json;

import com.atlassian.confluence.dmz.json.ConfluenceJsonFilterProvider;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluenceJsonObjectMapper
extends ObjectMapper {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceJsonObjectMapper.class);

    public ConfluenceJsonObjectMapper() {
        this.setFilterProvider(new ConfluenceJsonFilterProvider());
        this.setVisibility(this.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        this.disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_IS_GETTERS});
        this.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        this.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        this.activateDefaultTyping(this.getPolymorphicTypeValidator(), ObjectMapper.DefaultTyping.NON_FINAL, JsonTypeInfo.As.WRAPPER_ARRAY);
        this.writer().with((FilterProvider)new ConfluenceJsonFilterProvider());
    }

    public ObjectWriter writer() {
        return super.writer().with((FilterProvider)new ConfluenceJsonFilterProvider());
    }

    public String writeValueAsString(Object value) throws JsonProcessingException {
        return this.writer().writeValueAsString(value);
    }

    public String serialize(Object value) {
        try {
            return this.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> T deserialize(String value, Class<T> type) {
        if (value == null) {
            return null;
        }
        try {
            return (T)this.readValue(value, type);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> T deserialize(String value, TypeReference<T> typeRef) {
        if (value == null) {
            return null;
        }
        try {
            return (T)this.readValue(value, typeRef);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public <T> T deserializeOrNull(String value, Class<T> type) {
        try {
            return this.deserialize(value, type);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to deserialize String to type: {}", (Object)type.getName());
            return null;
        }
    }

    public <T> T deserializeOrNull(String value, TypeReference<T> typeRef) {
        try {
            return this.deserialize(value, typeRef);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to deserialize String to type: {}", (Object)typeRef.getType().getTypeName());
            return null;
        }
    }
}

