/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.dmz.labels;

import com.atlassian.confluence.api.model.pagination.LimitedRequest;
import com.atlassian.confluence.api.model.pagination.LimitedRequestImpl;
import com.atlassian.confluence.api.model.pagination.PageResponse;
import com.atlassian.confluence.api.model.pagination.PageResponseImpl;
import com.atlassian.confluence.core.PartialList;
import com.atlassian.confluence.labels.Label;
import com.atlassian.confluence.labels.LabelManager;
import com.atlassian.confluence.labels.Labelling;
import com.atlassian.confluence.labels.dto.LiteLabelSearchResult;
import com.atlassian.confluence.labels.persistence.dao.LabelSearchResult;

public interface LabelManagerInternal
extends LabelManager {
    public PageResponse<Label> findGlobalLabelsByNamePrefix(String var1, LimitedRequest var2);

    default public PageResponse<Label> findTeamLabelsByNamePrefix(String namePrefix, LimitedRequest pageRequest) {
        return PageResponseImpl.empty((boolean)false);
    }

    @Override
    default public PartialList<Label> findGlobalLabelsByNamePrefix(int offset, int maxResults, String namePrefix) {
        LimitedRequest request = LimitedRequestImpl.create((int)offset, (int)maxResults, (int)50);
        PageResponse<Label> response = this.findGlobalLabelsByNamePrefix(namePrefix, request);
        return PartialList.forAll(response.getResults());
    }

    @Override
    default public PartialList<Label> findTeamLabelsByNamePrefix(int offset, int maxResults, String namePrefix) {
        LimitedRequest request = LimitedRequestImpl.create((int)offset, (int)maxResults, (int)50);
        PageResponse<Label> response = this.findTeamLabelsByNamePrefix(namePrefix, request);
        return PartialList.forAll(response.getResults());
    }

    public PageResponse<Label> getLabelsInSpace(String var1, LimitedRequest var2);

    public PageResponse<Label> getRelatedLabelsInSpace(Label var1, String var2, LimitedRequest var3);

    public long getTotalLabelInSpace(String var1);

    public PageResponse<LabelSearchResult> getMostPopularLabelsInSpace(String var1, LimitedRequest var2);

    public PageResponse<LiteLabelSearchResult> getMostPopularLabelsInSiteLite(LimitedRequest var1);

    public PageResponse<LiteLabelSearchResult> getMostPopularLabelsInSpaceLite(String var1, LimitedRequest var2);

    public PageResponse<Label> getRecentlyUsedLabelsInSpace(String var1, LimitedRequest var2);

    public PageResponse<Labelling> getRecentlyUsedLabellingsInSpace(String var1, LimitedRequest var2);

    public PageResponse<Label> getRecentlyUsedPersonalLabels(String var1, LimitedRequest var2);

    public PageResponse<Labelling> getRecentlyUsedPersonalLabellings(String var1, LimitedRequest var2);

    public PageResponse<Label> getRelatedLabels(Label var1, LimitedRequest var2);

    public PageResponse<LabelSearchResult> getMostPopularLabels(LimitedRequest var1);

    public PageResponse<Label> getRecentlyUsedLabels(LimitedRequest var1);

    public PageResponse<Labelling> getRecentlyUsedLabellings(LimitedRequest var1);

    public PageResponse<Label> getLabelsByDetail(LimitedRequest var1, String var2, String var3, String var4, String var5);
}

