/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.dmz.spaces;

import com.atlassian.confluence.api.service.content.SpaceService;
import com.atlassian.confluence.core.persistence.hibernate.CacheMode;
import com.atlassian.confluence.core.persistence.hibernate.SessionCacheModeThreadLocal;
import com.atlassian.confluence.dmz.spaces.SpaceManagerInternal;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.Cleanup;
import com.atlassian.confluence.util.i18n.I18NBean;
import com.atlassian.confluence.util.longrunning.ConfluenceAbstractLongRunningTask;
import com.atlassian.sal.api.features.DarkFeatureManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SpaceRemovalLongRunningTask
extends ConfluenceAbstractLongRunningTask {
    private static final Logger log = LoggerFactory.getLogger(SpaceRemovalLongRunningTask.class);
    public static final String CONFLUENCE_FAST_SPACE_DELETION_FLAG = "confluence.fast-space-deletion";
    private final Long spaceId;
    private final String spaceKey;
    private final SpaceManagerInternal spaceManager;
    private final ConfluenceUser user;
    private final I18NBean i18n;
    private final DarkFeatureManager salDarkFeatureManager;
    private final SpaceService spaceService;

    @Deprecated
    public SpaceRemovalLongRunningTask(String spaceKey, SpaceManagerInternal spaceManager, ConfluenceUser user, I18NBean i18n) {
        log.warn("Usage of the deprecated SpaceRemovalLongRunningTask constructor detected!");
        this.spaceKey = spaceKey;
        this.spaceManager = spaceManager;
        this.user = user;
        this.i18n = i18n;
        this.spaceId = null;
        this.salDarkFeatureManager = null;
        this.spaceService = null;
    }

    public SpaceRemovalLongRunningTask(long spaceId, String spaceKey, SpaceManagerInternal spaceManager, ConfluenceUser user, I18NBean i18n, DarkFeatureManager salDarkFeatureManager, SpaceService spaceService) {
        this.spaceId = spaceId;
        this.spaceKey = spaceKey;
        this.spaceManager = spaceManager;
        this.user = user;
        this.i18n = i18n;
        this.salDarkFeatureManager = salDarkFeatureManager;
        this.spaceService = spaceService;
    }

    @Override
    protected void runInternal() {
        try (Cleanup cleanup = SessionCacheModeThreadLocal.temporarilySetCacheMode((CacheMode)CacheMode.IGNORE);){
            AuthenticatedUserThreadLocal.set(this.user);
            if (this.deleteViaFastSpaceDeletion()) {
                return;
            }
            if (!this.spaceManager.removeSpace(this.spaceKey, this.progress).booleanValue()) {
                this.progress.setStatus(this.i18n.getText("progress.remove.space.failed"));
                this.progress.setCompletedSuccessfully(false);
                log.warn("Removing the space with key '{}' failed", (Object)this.spaceKey);
            } else {
                log.info("Successfully removed the space with key '{}'", (Object)this.spaceKey);
            }
        }
    }

    private boolean deleteViaFastSpaceDeletion() {
        try {
            if (!this.isFastDeletionEnabled() || this.spaceId == null) {
                return false;
            }
            this.progress.setStatus(this.i18n.getText("progress.remove.space.start"));
            this.spaceService.delete(this.spaceId.longValue());
            log.info("The space with id {} and key '{}' has been hidden, space key can be re-used. It will be completely deleted in background.", (Object)this.spaceId, (Object)this.spaceKey);
            this.progress.setCompletedSuccessfully(true);
            this.progress.setPercentage(100);
            this.progress.setStatus(this.i18n.getText("progress.remove.space.finished"));
            return true;
        }
        catch (Exception e) {
            this.progress.setStatus(this.i18n.getText("progress.remove.space.failed"));
            log.warn("Removing the space with key '{}' failed", (Object)this.spaceKey, (Object)e);
            this.progress.setCompletedSuccessfully(false);
            return false;
        }
    }

    public String getName() {
        return "Space removal long running task";
    }

    private boolean isFastDeletionEnabled() {
        return this.spaceService != null && this.salDarkFeatureManager != null && this.salDarkFeatureManager.isEnabledForAllUsers(CONFLUENCE_FAST_SPACE_DELETION_FLAG).orElse(false) != false;
    }
}

