/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.dmz.struts;

import com.atlassian.confluence.cache.ThreadLocalCacheAccessor;
import com.atlassian.confluence.plugin.struts.PluginAwareActionConfig;
import jakarta.servlet.http.HttpServletRequest;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.RequestUtils;
import org.apache.struts2.config.entities.ActionConfig;
import org.apache.struts2.dispatcher.Dispatcher;
import org.apache.struts2.dispatcher.mapper.ActionMapping;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedAction {
    private static final Logger LOG = LoggerFactory.getLogger(MappedAction.class);
    private static final ThreadLocalCacheAccessor<CacheKey, Optional<MappedAction>> cacheAccessor = ThreadLocalCacheAccessor.newInstance();
    private final String actionName;
    private final String actionPackage;
    private final Class<?> actionClass;
    private final Method actionMethod;
    private final Map<String, String> actionParams;
    private final String requestServletPath;

    private MappedAction(String actionName, String actionPackage, Class<?> actionClass, Method actionMethod, Map<String, String> actionParams, String requestServletPath) {
        this.actionName = actionName;
        this.actionPackage = actionPackage;
        this.actionClass = actionClass;
        this.actionMethod = actionMethod;
        this.actionParams = actionParams;
        this.requestServletPath = requestServletPath;
    }

    public String getActionName() {
        return this.actionName;
    }

    public String getActionPackageName() {
        return this.actionPackage;
    }

    public Class<?> getActionClass() {
        return this.actionClass;
    }

    public Method getActionMethod() {
        return this.actionMethod;
    }

    public Map<String, String> getActionParams() {
        return this.actionParams;
    }

    public String getRequestServletPath() {
        return this.requestServletPath;
    }

    public static @Nullable MappedAction of(Dispatcher dispatcher, HttpServletRequest request) {
        return cacheAccessor.getOrCompute(new CacheKey(request.getRequestURI()), () -> Optional.ofNullable(MappedAction.ofInternal(dispatcher, request))).orElse(null);
    }

    public static Method getActionClassMethod(Class<?> actionClass, @Nullable String methodName) {
        try {
            return actionClass.getMethod(Objects.requireNonNullElse(methodName, "execute"), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("action method [ " + methodName + " ] not found on [ " + actionClass.getName() + " ]", e);
        }
    }

    private static @Nullable MappedAction ofInternal(Dispatcher dispatcher, HttpServletRequest request) {
        ActionConfig actionConfig = MappedAction.getActionConfig(dispatcher, request);
        if (actionConfig == null) {
            return null;
        }
        Class<?> actionClass = MappedAction.resolveActionClass(actionConfig);
        Method actionMethod = MappedAction.getActionClassMethod(actionClass, actionConfig.getMethodName());
        return new MappedAction(actionConfig.getName(), actionConfig.getPackageName(), actionClass, actionMethod, Collections.unmodifiableMap(actionConfig.getParams()), request.getServletPath());
    }

    private static @Nullable ActionConfig getActionConfig(Dispatcher dispatcher, HttpServletRequest request) {
        ActionMapping actionMapping = MappedAction.getActionMapping(dispatcher, request);
        if (actionMapping == null) {
            LOG.debug("No ActionMapping found for {}", (Object)StringUtils.normalizeSpace((String)request.getRequestURI()));
            return null;
        }
        ActionConfig actionConfig = MappedAction.getActionConfig(dispatcher, actionMapping);
        if (actionConfig == null) {
            LOG.debug("ActionMapping could not be resolved for {}", (Object)StringUtils.normalizeSpace((String)request.getRequestURI()));
            return null;
        }
        return actionConfig;
    }

    private static @Nullable ActionMapping getActionMapping(Dispatcher dispatcher, HttpServletRequest request) {
        ActionMapping actionMapping = null;
        if (!MappedAction.isUrlExcluded(dispatcher, request)) {
            actionMapping = dispatcher.getActionMapper().getMapping(request, dispatcher.getConfigurationManager());
        }
        return actionMapping;
    }

    private static boolean isUrlExcluded(Dispatcher dispatcher, HttpServletRequest request) {
        String uri = RequestUtils.getUri((HttpServletRequest)request);
        return dispatcher.getActionExcludedPatterns().stream().anyMatch(pattern -> pattern.matcher(uri).matches());
    }

    private static @Nullable ActionConfig getActionConfig(Dispatcher dispatcher, ActionMapping mapping) {
        return dispatcher.getConfigurationManager().getConfiguration().getRuntimeConfiguration().getActionConfig(mapping.getNamespace(), mapping.getName());
    }

    private static Class<?> resolveActionClass(ActionConfig actionConfig) {
        try {
            if (actionConfig instanceof PluginAwareActionConfig) {
                PluginAwareActionConfig pluginAware = (PluginAwareActionConfig)actionConfig;
                return pluginAware.getPlugin().loadClass(actionConfig.getClassName(), MappedAction.class);
            }
            return MappedAction.class.getClassLoader().loadClass(actionConfig.getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Error loading action class", e);
        }
    }

    private record CacheKey(String uri) {
    }
}

