/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event;

import com.atlassian.event.internal.AsynchronousAbleEventDispatcher;
import com.atlassian.event.internal.AsynchronousEventResolver;
import com.atlassian.event.spi.EventExecutorFactory;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.Executor;

public class ConfluenceEventDispatcher<C>
extends AsynchronousAbleEventDispatcher {
    private final ThreadLocalContextManager<C> threadLocalContextManager;

    public ConfluenceEventDispatcher(EventExecutorFactory executorFactory, AsynchronousEventResolver asynchronousEventResolver, ThreadLocalContextManager<C> threadLocalContextManager) {
        super(executorFactory, asynchronousEventResolver);
        this.threadLocalContextManager = threadLocalContextManager;
    }

    protected Executor getAsynchronousExecutor() {
        return this.wrap(super.getAsynchronousExecutor());
    }

    @VisibleForTesting
    public Executor getInternalExecutor() {
        return super.getAsynchronousExecutor();
    }

    private Executor wrap(Executor delegate) {
        return command -> {
            final Object parentContext = this.threadLocalContextManager.getThreadLocalContext();
            delegate.execute(new Runnable(){

                @Override
                public void run() {
                    Object childContext = ConfluenceEventDispatcher.this.threadLocalContextManager.getThreadLocalContext();
                    ConfluenceEventDispatcher.this.threadLocalContextManager.setThreadLocalContext(parentContext);
                    try {
                        command.run();
                    }
                    finally {
                        ConfluenceEventDispatcher.this.threadLocalContextManager.setThreadLocalContext(childContext);
                    }
                }

                public String toString() {
                    return command.toString();
                }
            });
        };
    }
}

