/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event;

import com.atlassian.confluence.event.ConfluenceListenerInvoker;
import com.atlassian.confluence.server.ApplicationStatusService;
import com.atlassian.confluence.util.profiling.DurationThresholdWarningTimingHelper;
import com.atlassian.confluence.util.profiling.DurationThresholdWarningTimingHelperFactory;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.config.ListenerHandlersConfiguration;
import com.atlassian.event.internal.AnnotatedMethodsListenerHandler;
import com.atlassian.event.spi.ListenerHandler;
import com.atlassian.event.spi.ListenerInvoker;
import com.atlassian.plugin.event.PluginEventListener;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ConfluenceListenerHandlersConfiguration
implements ListenerHandlersConfiguration {
    public static final String EVENT_LISTENER_WARN_THRESHOLD_SYSTEM_PROPERTY = "confluence.events.listenerWarnThresholdMillis";
    private static final Duration EVENT_LISTENER_WARN_THRESHOLD_DEFAULT = null;
    private final ApplicationStatusService applicationStatusService;

    public ConfluenceListenerHandlersConfiguration(ApplicationStatusService applicationStatusService) {
        this.applicationStatusService = applicationStatusService;
    }

    public @NonNull List<ListenerHandler> getListenerHandlers() {
        return Arrays.asList(new TimingListenerHandler((ListenerHandler)new AnnotatedMethodsListenerHandler(EventListener.class)), new TimingListenerHandler((ListenerHandler)new AnnotatedMethodsListenerHandler(PluginEventListener.class)));
    }

    private class TimingListenerHandler
    implements ListenerHandler {
        private final ListenerHandler delegate;
        private final DurationThresholdWarningTimingHelper timingHelper;

        TimingListenerHandler(ListenerHandler delegate) {
            this.delegate = delegate;
            this.timingHelper = DurationThresholdWarningTimingHelperFactory.createFromSystemProperty(ConfluenceListenerHandlersConfiguration.EVENT_LISTENER_WARN_THRESHOLD_SYSTEM_PROPERTY, EVENT_LISTENER_WARN_THRESHOLD_DEFAULT);
        }

        public List<ListenerInvoker> getInvokers(Object listener) {
            return this.delegate.getInvokers(listener).stream().map(listenerInvoker -> this.wrapInvoker((ListenerInvoker)listenerInvoker, listener.getClass())).collect(Collectors.toList());
        }

        private ListenerInvoker wrapInvoker(ListenerInvoker listenerInvoker, Class<?> listenerClass) {
            return new ConfluenceListenerInvoker(listenerInvoker, listenerClass, ConfluenceListenerHandlersConfiguration.this.applicationStatusService.getState(), this.timingHelper);
        }
    }
}

