/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event;

import com.atlassian.confluence.event.DelegatingListenerInvoker;
import com.atlassian.confluence.server.ApplicationState;
import com.atlassian.confluence.util.profiling.DurationThresholdWarningTimingHelper;
import com.atlassian.event.spi.ListenerInvoker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfluenceListenerInvoker
extends DelegatingListenerInvoker {
    private static final Logger log = LoggerFactory.getLogger(ConfluenceListenerInvoker.class);
    private final DurationThresholdWarningTimingHelper timingHelper;
    private final Class<?> listenerClass;
    private final ApplicationState state;

    ConfluenceListenerInvoker(ListenerInvoker delegate, Class<?> listenerClass, ApplicationState state, DurationThresholdWarningTimingHelper timingHelper) {
        super(delegate);
        this.listenerClass = listenerClass;
        this.state = state;
        this.timingHelper = timingHelper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Object event) {
        DurationThresholdWarningTimingHelper.Timer timer = this.createTimer(event).start();
        try {
            super.invoke(event);
        }
        catch (RuntimeException ex) {
            this.log(ex, event.getClass());
        }
        finally {
            timer.stopAndCheckTiming();
        }
    }

    private void log(RuntimeException ex, Class<?> eventClass) {
        log.error("{} occurred dispatching {} to [{}]", new Object[]{ex.getClass().getName(), eventClass.getName(), this.listenerClass.getName(), ex});
    }

    private DurationThresholdWarningTimingHelper.Timer createTimer(Object event) {
        return this.timingHelper.newDescribedTimer(() -> this.descriptionOf(event), this.areWarningsDisabled());
    }

    public String toString() {
        return super.toString() + " (timed)";
    }

    private boolean areWarningsDisabled() {
        return this.state != ApplicationState.RUNNING;
    }

    private String descriptionOf(Object event) {
        return "publishing event " + String.valueOf(event) + " to listener " + this.listenerClass.getName();
    }
}

