/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event.listeners;

import com.atlassian.confluence.util.MemoizingComponentReference;
import jakarta.servlet.http.HttpSessionAttributeListener;
import jakarta.servlet.http.HttpSessionBindingEvent;
import java.util.function.Supplier;
import org.springframework.security.core.session.SessionRegistry;

public final class HttpSessionRegistrarAttributeListener
implements HttpSessionAttributeListener {
    private final Supplier<SessionRegistry> registry = MemoizingComponentReference.containerComponent("sessionRegistry");

    public void attributeAdded(HttpSessionBindingEvent event) {
        if (this.supportsAttribute(event)) {
            this.sessionRegistry().registerNewSession(event.getSession().getId(), event.getValue());
        }
    }

    public void attributeRemoved(HttpSessionBindingEvent event) {
        if (this.supportsAttribute(event)) {
            this.sessionRegistry().removeSessionInformation(event.getSession().getId());
        }
    }

    public void attributeReplaced(HttpSessionBindingEvent event) {
    }

    private boolean supportsAttribute(HttpSessionBindingEvent event) {
        return event.getName().equals("seraph_defaultauthenticator_user");
    }

    private SessionRegistry sessionRegistry() {
        return this.registry.get();
    }
}

