/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.event.listeners;

import com.atlassian.confluence.event.events.admin.ResetHibernateIdRangeEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEvent;
import com.atlassian.confluence.event.events.cluster.ClusterEventWrapper;
import com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGenerator;
import com.atlassian.event.api.EventListener;
import com.atlassian.spring.container.ContainerManager;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.persister.entity.EntityPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResetHiLoAfterImportListener {
    private static final Logger log = LoggerFactory.getLogger(ResetHiLoAfterImportListener.class);

    @EventListener
    public void handleEvent(ClusterEventWrapper event) {
        ClusterEvent wrapped = event.getEvent();
        if (wrapped instanceof ResetHibernateIdRangeEvent) {
            this.handleEvent((ResetHibernateIdRangeEvent)wrapped);
        }
    }

    @EventListener
    public void handleEvent(ResetHibernateIdRangeEvent event) {
        this.forceReadOfHiLo();
        log.info("Reset Hi/Lo ids in response to import event");
    }

    private void forceReadOfHiLo() {
        SessionFactoryImplementor sessionFactory = (SessionFactoryImplementor)ContainerManager.getComponent((String)"sessionFactory", SessionFactoryImplementor.class);
        this.forceReadOfHiLo(sessionFactory);
    }

    private void forceReadOfHiLo(SessionFactoryImplementor sessionFactory) {
        for (String entityName : sessionFactory.getMetamodel().getAllEntityNames()) {
            EntityPersister persister = sessionFactory.getMetamodel().entityPersister(entityName);
            IdentifierGenerator idGen = persister.getIdentifierGenerator();
            if (!(idGen instanceof ResettableTableHiLoGenerator)) continue;
            ((ResettableTableHiLoGenerator)idGen).reset();
        }
    }
}

