/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.follow;

import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import jakarta.persistence.Access;
import jakarta.persistence.AccessType;
import jakarta.persistence.Cacheable;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.ForeignKey;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Target;

@Entity
@Table(name="FOLLOW_CONNECTIONS", indexes={@Index(name="cn_follower_idx", columnList="FOLLOWER"), @Index(name="cn_followee_idx", columnList="FOLLOWEE")})
@Cacheable
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
@Access(value=AccessType.FIELD)
@Proxy(lazy=false)
public class Connection {
    @Id
    @Column(name="CONNECTIONID")
    @GeneratedValue(generator="resettable-hilo-v5")
    @GenericGenerator(name="resettable-hilo-v5", strategy="com.atlassian.confluence.impl.hibernate.ResettableTableHiLoGeneratorV5")
    private long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FOLLOWER", foreignKey=@ForeignKey(name="FK_FOLLOW_CONNECTIONS_FOLLOWER"))
    @Target(value=ConfluenceUserImpl.class)
    private ConfluenceUser follower;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="FOLLOWEE", foreignKey=@ForeignKey(name="FK_FOLLOW_CONNECTIONS_FOLLOWEE"))
    @Target(value=ConfluenceUserImpl.class)
    private ConfluenceUser followee;

    public Connection() {
    }

    public Connection(ConfluenceUser follower, ConfluenceUser followee) {
        this.follower = follower;
        this.followee = followee;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public ConfluenceUser getFollowerUser() {
        return this.follower;
    }

    public ConfluenceUser getFolloweeUser() {
        return this.followee;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.id).append((Object)this.follower).append((Object)this.followee).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Connection)) {
            return false;
        }
        Connection that = (Connection)obj;
        return new EqualsBuilder().append(this.id, that.id).append((Object)this.follower, (Object)that.follower).append((Object)this.followee, (Object)that.followee).isEquals();
    }
}

