/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.follow;

import com.atlassian.confluence.follow.Connection;
import com.atlassian.confluence.user.ConfluenceUser;
import jakarta.persistence.QueryHint;
import java.util.List;
import java.util.Optional;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.jpa.repository.QueryHints;
import org.springframework.stereotype.Repository;

@Repository
public interface ConnectionRepository
extends JpaRepository<Connection, Long> {
    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="select c.follower from Connection c where c.followee = :followee order by c.follower.name asc")
    public List<ConfluenceUser> findFollowers(ConfluenceUser var1, int var2, int var3);

    @QueryHints(value={@QueryHint(name="org.hibernate.cacheable", value="true")})
    @Query(value="select c.followee from Connection c where c.follower = :follower order by c.followee.name asc")
    public List<ConfluenceUser> findFollowees(ConfluenceUser var1, int var2, int var3);

    public Optional<Connection> findByFollowerAndFollowee(ConfluenceUser var1, ConfluenceUser var2);

    default public boolean isUserFollowing(ConfluenceUser follower, ConfluenceUser followee) {
        if (follower == null || followee == null) {
            return false;
        }
        return this.findByFollowerAndFollowee(follower, followee).isPresent();
    }

    default public void followUser(ConfluenceUser follower, ConfluenceUser followee) {
        if (follower == null || followee == null) {
            return;
        }
        if (!this.isUserFollowing(follower, followee)) {
            this.save(new Connection(follower, followee));
        }
    }

    default public void unfollowUser(ConfluenceUser follower, ConfluenceUser followee) {
        this.findByFollowerAndFollowee(follower, followee).ifPresent(arg_0 -> ((ConnectionRepository)this).delete(arg_0));
    }

    public void deleteByFollowerOrFollowee(ConfluenceUser var1, ConfluenceUser var2);

    default public void removeAllConnectionsFor(ConfluenceUser user) {
        if (user != null) {
            this.deleteByFollowerOrFollowee(user, user);
        }
    }
}

