/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.activeobjects;

import com.atlassian.activeobjects.spi.ConnectionHandler;
import com.atlassian.activeobjects.spi.DataSourceProvider;
import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.config.db.HibernateConfig;
import com.atlassian.confluence.impl.hibernate.DataAccessUtils;
import com.atlassian.confluence.status.service.SystemInformationService;
import io.atlassian.util.concurrent.Lazy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.jdbc.datasource.AbstractDataSource;

public final class ActiveObjectsDataSourceProvider
implements DataSourceProvider {
    private final DataSourceWrapper dataSource = new DataSourceWrapper(() -> DataAccessUtils.getConnection(sessionFactory.getCurrentSession()));
    private final Supplier<String> dialectRef = Lazy.supplier(() -> ActiveObjectsDataSourceProvider.getDialect(systemInformationService));

    public ActiveObjectsDataSourceProvider(SystemInformationService systemInformationService, SessionFactoryImplementor sessionFactory) {
    }

    public @NonNull DataSource getDataSource() {
        return this.dataSource;
    }

    public @NonNull DatabaseType getDatabaseType() {
        String dialect = this.dialectRef.get();
        if (dialect == null) {
            return DatabaseType.UNKNOWN;
        }
        if (HibernateConfig.isHsqlDialect((String)dialect)) {
            return DatabaseType.HSQL;
        }
        if (HibernateConfig.isH2Dialect((String)dialect)) {
            return DatabaseType.H2;
        }
        if (HibernateConfig.isMySqlDialect((String)dialect)) {
            return DatabaseType.MYSQL;
        }
        if (HibernateConfig.isPostgreSqlDialect((String)dialect)) {
            return DatabaseType.POSTGRESQL;
        }
        if (HibernateConfig.isOracleDialect((String)dialect)) {
            return DatabaseType.ORACLE;
        }
        if (HibernateConfig.isSqlServerDialect((String)dialect)) {
            return DatabaseType.MS_SQL;
        }
        return DatabaseType.UNKNOWN;
    }

    public @Nullable String getSchema() {
        return null;
    }

    private static String getDialect(SystemInformationService systemInformationService) {
        return systemInformationService.getSafeDatabaseInfo().getDialect();
    }

    private static Connection wrap(Connection connection) {
        return ConnectionHandler.newInstance((Connection)connection);
    }

    private static class DataSourceWrapper
    extends AbstractDataSource {
        private final Supplier<Connection> connectionSupplier;

        DataSourceWrapper(Supplier<Connection> connectionSupplier) {
            this.connectionSupplier = Objects.requireNonNull(connectionSupplier);
        }

        public Connection getConnection() throws SQLException {
            return ActiveObjectsDataSourceProvider.wrap(this.connectionSupplier.get());
        }

        public Connection getConnection(String username, String password) {
            throw new UnsupportedOperationException();
        }
    }
}

