/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.activeobjects;

import com.atlassian.activeobjects.spi.TransactionSynchronisationManager;
import com.atlassian.confluence.impl.transaction.SynchronizationManagerInternal;
import org.springframework.transaction.support.TransactionSynchronization;

public class ActiveObjectsTransactionSynchronisationManager
implements TransactionSynchronisationManager {
    private final SynchronizationManagerInternal synchronisationManager;

    public ActiveObjectsTransactionSynchronisationManager(SynchronizationManagerInternal synchManager) {
        this.synchronisationManager = synchManager;
    }

    public boolean runOnRollBack(final Runnable callback) {
        if (this.synchronisationManager.isTransactionActive()) {
            this.synchronisationManager.registerSynchronization(new TransactionSynchronization(){

                public void afterCompletion(int status) {
                    if (status == 1) {
                        callback.run();
                    }
                }
            });
            return true;
        }
        return false;
    }

    public boolean runOnSuccessfulCommit(Runnable callback) {
        if (this.synchronisationManager.isTransactionActive()) {
            this.synchronisationManager.runOnSuccessfulCommit(callback);
            return true;
        }
        return false;
    }

    public boolean isActiveSynchronisedTransaction() {
        return this.synchronisationManager.isTransactionActive();
    }
}

