/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.admin.actions;

import com.atlassian.annotations.security.AdminOnly;
import com.atlassian.confluence.cluster.ClusterExecutionService;
import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.atlassian.confluence.impl.logging.LogAppenderController;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.google.common.annotations.VisibleForTesting;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.interceptor.parameter.StrutsParameter;

@AdminOnly
public class MarkAllLogsAction
extends ConfluenceActionSupport {
    @VisibleForTesting
    static Logger log = Logger.getLogger(MarkAllLogsAction.class);
    @VisibleForTesting
    static Runnable rolloverRunner = LogAppenderController::rolloverAppenders;
    private String nodeId;
    private MarkLogsTask task = new MarkLogsTask();
    private ClusterExecutionService clusterManager;

    @StrutsParameter
    public void setNodeId(String nodeId) {
        this.nodeId = nodeId;
    }

    @StrutsParameter
    public void setLogsMarkMessage(String logsMarkMessage) {
        this.task.message = logsMarkMessage;
    }

    @StrutsParameter
    public void setLogsMarkRollover(boolean logsMarkRollover) {
        this.task.rollover = logsMarkRollover;
    }

    @Override
    public boolean isPermitted() {
        return this.permissionManager.hasPermission(this.getAuthenticatedUser(), Permission.ADMINISTER, PermissionManager.TARGET_APPLICATION);
    }

    public void setClusterManager(ClusterExecutionService clusterManager) {
        this.clusterManager = clusterManager;
    }

    public String execute() throws Exception {
        this.clusterManager.submitToNode(StringUtils.trimToNull((String)this.nodeId), (Callable)this.task, "cluster-manager-executor").getCompletionStage().toCompletableFuture().get();
        return "success";
    }

    private static class MarkLogsTask
    implements Callable<Void>,
    Serializable {
        String message;
        boolean rollover;

        private MarkLogsTask() {
        }

        @Override
        public Void call() throws Exception {
            log.info((Object)"");
            if (this.rollover) {
                rolloverRunner.run();
            }
            log.info((Object)("\n************************************************\n" + this.message + "\n************************************************\n"));
            return null;
        }
    }
}

