/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.audit.listener;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.confluence.audit.AuditingContext;
import com.atlassian.confluence.audit.StandardAuditResourceTypes;
import com.atlassian.confluence.event.events.security.SecretDeletedEvent;
import com.atlassian.confluence.event.events.security.SecretUpdatedEvent;
import com.atlassian.confluence.impl.audit.AuditCategories;
import com.atlassian.confluence.impl.audit.AuditHelper;
import com.atlassian.confluence.impl.audit.handler.AuditHandlerService;
import com.atlassian.confluence.impl.audit.listener.AbstractAuditListener;
import com.atlassian.event.api.EventListener;

public class SecretAuditListener
extends AbstractAuditListener {
    public static final String SECRET_UPDATED_SUMMARY = AuditHelper.buildSummaryTextKey("security.secret.updated");
    public static final String SECRET_DELETED_SUMMARY = AuditHelper.buildSummaryTextKey("security.secret.deleted");

    public SecretAuditListener(AuditHandlerService auditHandlerService, AuditService service, AuditHelper auditHelper, StandardAuditResourceTypes resourceTypes, AuditingContext auditingContext) {
        super(auditHandlerService, service, auditHelper, resourceTypes, auditingContext);
    }

    @EventListener
    public void secretUpdatedEvent(SecretUpdatedEvent event) {
        this.save(() -> AuditEvent.builder((AuditType)this.buildAuditType(SECRET_UPDATED_SUMMARY)).affectedObject(this.buildResourceWithoutId(event.secretIdentifier(), this.resourceTypes.secret())).build());
    }

    @EventListener
    public void secretDeletedEvent(SecretDeletedEvent event) {
        this.save(() -> AuditEvent.builder((AuditType)this.buildAuditType(SECRET_DELETED_SUMMARY)).affectedObject(this.buildResourceWithoutId(event.secretIdentifier(), this.resourceTypes.secret())).build());
    }

    private AuditType buildAuditType(String summaryKey) {
        return AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)CoverageLevel.BASE, (String)AuditCategories.SECURITY, (String)summaryKey).build();
    }
}

