/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.audit.listener;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.AuditType;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.confluence.audit.AuditingContext;
import com.atlassian.confluence.audit.StandardAuditResourceTypes;
import com.atlassian.confluence.event.events.security.SpaceFilteringUpdatedEvent;
import com.atlassian.confluence.impl.audit.AuditCategories;
import com.atlassian.confluence.impl.audit.AuditHelper;
import com.atlassian.confluence.impl.audit.handler.AuditHandlerService;
import com.atlassian.confluence.impl.audit.listener.AbstractAuditListener;
import com.atlassian.event.api.EventListener;
import java.util.ArrayList;
import java.util.List;

public class SpaceFilteringSettingsAuditListener
extends AbstractAuditListener {
    public static final String SPACE_FILTERING_LIST_UPDATED_SUMMARY = AuditHelper.buildSummaryTextKey("space.filtering.list.updated");
    public static final String EXTRA_ATTRIBUTE_SPACE_KEYS = AuditHelper.buildExtraAttribute("space.filtering.space.keys");
    public static final String EXTRA_ATTRIBUTE_OPT_IN_NEW_SPACES = AuditHelper.buildExtraAttribute("space.filtering.opt.in.new.spaces");
    public static final String EXTRA_ATTRIBUTE_UPDATE_TYPE = AuditHelper.buildExtraAttribute("space.filtering.update.type");
    public static final String EXTRA_ATTRIBUTE_SOURCE = AuditHelper.buildExtraAttribute("space.filtering.source");

    public SpaceFilteringSettingsAuditListener(AuditHandlerService auditHandlerService, AuditService service, AuditHelper auditHelper, StandardAuditResourceTypes resourceTypes, AuditingContext auditingContext) {
        super(auditHandlerService, service, auditHelper, resourceTypes, auditingContext);
    }

    @EventListener
    public void spaceExclusionUpdatedEvent(SpaceFilteringUpdatedEvent event) {
        this.save(() -> AuditEvent.builder((AuditType)this.buildAuditType()).extraAttributes(this.buildExtraAttributes(event)).build());
    }

    private AuditType buildAuditType() {
        return AuditType.fromI18nKeys((CoverageArea)CoverageArea.SECURITY, (CoverageLevel)CoverageLevel.BASE, (String)AuditCategories.SYSTEM, (String)SPACE_FILTERING_LIST_UPDATED_SUMMARY).build();
    }

    private List<AuditAttribute> buildExtraAttributes(SpaceFilteringUpdatedEvent event) {
        ArrayList<AuditAttribute> extraAttributes = new ArrayList<AuditAttribute>();
        if (event.spaceKeys() != null) {
            extraAttributes.add(AuditAttribute.fromI18nKeys((String)EXTRA_ATTRIBUTE_SPACE_KEYS, (String)String.join((CharSequence)", ", event.spaceKeys())).build());
        }
        if (event.updateType() != null) {
            extraAttributes.add(AuditAttribute.fromI18nKeys((String)EXTRA_ATTRIBUTE_UPDATE_TYPE, (String)String.valueOf((Object)event.updateType())).build());
        }
        if (event.source() != null) {
            extraAttributes.add(AuditAttribute.fromI18nKeys((String)EXTRA_ATTRIBUTE_SOURCE, (String)event.source()).build());
        }
        extraAttributes.add(AuditAttribute.fromI18nKeys((String)EXTRA_ATTRIBUTE_OPT_IN_NEW_SPACES, (String)String.valueOf(event.optInNewSpaces())).build());
        return extraAttributes;
    }
}

