/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backgroundjob;

import com.atlassian.confluence.impl.backgroundjob.BackgroundJobProcessor;
import com.atlassian.confluence.impl.backgroundjob.BackgroundJobResponse;
import com.atlassian.confluence.impl.backgroundjob.BackgroundJobService;
import com.atlassian.confluence.impl.backgroundjob.dao.BackgroundJobDAO;
import com.atlassian.confluence.impl.backgroundjob.domain.ArchivedBackgroundJob;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.interceptor.DefaultTransactionAttribute;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class BackgroundJobCleaner
implements BackgroundJobProcessor {
    private final BackgroundJobDAO backgroundJobDAO;
    private final BackgroundJobService backgroundJobService;
    private final PlatformTransactionManager transactionManager;
    private final int COMPLETED_BACKGROUND_JOBS_TTL = Integer.getInteger("confluence.backgroundjobs.completed-jobs-ttl-in-days", 7);
    private final int COMPLETED_BACKGROUND_JOBS_BATCH_SIZE = Integer.getInteger("confluence.backgroundjobs.completed-jobs-batch-size", 50);

    public BackgroundJobCleaner(BackgroundJobDAO backgroundJobDAO, BackgroundJobService backgroundJobService, PlatformTransactionManager transactionManager) {
        this.backgroundJobDAO = backgroundJobDAO;
        this.backgroundJobService = backgroundJobService;
        this.transactionManager = transactionManager;
    }

    @PostConstruct
    void register() {
        this.backgroundJobService.registerBackgroundJobProcessor(this);
    }

    @PreDestroy
    void unregister() {
        this.backgroundJobService.unregisterBackgroundJobProcessor(this);
    }

    @Override
    public BackgroundJobResponse process(Long jobId, Map<String, Object> parameters, long recommendedTimeout) {
        Instant date = Instant.now().minus(this.COMPLETED_BACKGROUND_JOBS_TTL, ChronoUnit.DAYS);
        List backgroundJobsToRemove = (List)this.doInTransaction(tx -> {
            List<ArchivedBackgroundJob> jobsToRemove = this.backgroundJobDAO.getObsoleteArchivedJobs(date, this.COMPLETED_BACKGROUND_JOBS_BATCH_SIZE);
            jobsToRemove.forEach(this.backgroundJobDAO::removeArchivedJob);
            return jobsToRemove;
        });
        if (backgroundJobsToRemove.size() < this.COMPLETED_BACKGROUND_JOBS_BATCH_SIZE) {
            return BackgroundJobResponse.scheduleNextRun(ChronoUnit.DAYS, 1, Collections.emptyMap());
        }
        return BackgroundJobResponse.scheduleNextRun(ChronoUnit.MINUTES, 1, Collections.emptyMap());
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    private <T> T doInTransaction(TransactionCallback<T> callback) {
        DefaultTransactionAttribute transactionAttribute = new DefaultTransactionAttribute(3);
        return (T)new TransactionTemplate(this.transactionManager, (TransactionDefinition)transactionAttribute).execute(callback);
    }
}

