/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backgroundjob.dao;

import com.atlassian.confluence.impl.backgroundjob.domain.ArchivedBackgroundJob;
import com.atlassian.confluence.impl.backgroundjob.domain.BackgroundJob;
import java.io.Serializable;
import java.time.Instant;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.query.Query;

public class BackgroundJobDAO {
    private final SessionFactory sessionFactory;

    public BackgroundJobDAO(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void save(BackgroundJob job) {
        this.sessionFactory.getCurrentSession().save((Object)job);
    }

    public void saveArchived(ArchivedBackgroundJob job) {
        this.sessionFactory.getCurrentSession().save((Object)job);
    }

    public void update(BackgroundJob job) {
        this.sessionFactory.getCurrentSession().update((Object)job);
    }

    public void updateArchived(ArchivedBackgroundJob job) {
        this.sessionFactory.getCurrentSession().update((Object)job);
    }

    public void delete(BackgroundJob job) {
        this.sessionFactory.getCurrentSession().delete((Object)job);
    }

    public List<BackgroundJob> getAllJobsReadyToRunSortedById(Instant now) {
        Session session = this.sessionFactory.getCurrentSession();
        String hql = "from BackgroundJob job where job.runAt <= :now order by id";
        Query query = session.createQuery("from BackgroundJob job where job.runAt <= :now order by id", BackgroundJob.class);
        query.setParameter("now", (Object)now);
        query.setCacheable(false);
        return query.list();
    }

    public List<BackgroundJob> findActiveJobsByType(String type) {
        Session session = this.sessionFactory.getCurrentSession();
        String hql = "from BackgroundJob job where job.type = :type";
        Query query = session.createQuery("from BackgroundJob job where job.type = :type", BackgroundJob.class);
        query.setParameter("type", (Object)type);
        query.setCacheable(false);
        return query.list();
    }

    public void remove(BackgroundJob job) {
        this.sessionFactory.getCurrentSession().delete((Object)job);
    }

    public void removeArchivedJob(ArchivedBackgroundJob job) {
        this.sessionFactory.getCurrentSession().delete((Object)job);
    }

    public List<ArchivedBackgroundJob> getObsoleteArchivedJobs(Instant date, int limit) {
        Session session = this.sessionFactory.getCurrentSession();
        String hql = "from ArchivedBackgroundJob job where job.completionTime <= :completionTime";
        Query query = session.createQuery("from ArchivedBackgroundJob job where job.completionTime <= :completionTime", ArchivedBackgroundJob.class);
        query.setParameter("completionTime", (Object)date);
        query.setCacheable(false);
        query.setMaxResults(limit);
        return query.list();
    }

    public BackgroundJob getActiveJobById(long id) {
        return (BackgroundJob)this.sessionFactory.getCurrentSession().get(BackgroundJob.class, (Serializable)Long.valueOf(id));
    }

    public ArchivedBackgroundJob getArchivedJobById(long id) {
        return (ArchivedBackgroundJob)this.sessionFactory.getCurrentSession().get(ArchivedBackgroundJob.class, (Serializable)Long.valueOf(id));
    }
}

