/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore;

import com.atlassian.confluence.api.model.backuprestore.JobOperation;
import com.atlassian.confluence.api.model.backuprestore.JobScope;
import com.atlassian.confluence.api.model.backuprestore.JobState;
import com.atlassian.confluence.backuprestore.BackupRestoreJob;
import com.atlassian.confluence.backuprestore.BackupRestoreJobsSearchFilter;
import com.atlassian.confluence.backuprestore.BackupRestoreSettings;
import com.atlassian.confluence.backuprestore.exception.BackupRestoreException;
import com.atlassian.confluence.impl.backuprestore.converters.JsonToPublicSettingsConverter;
import com.atlassian.confluence.impl.backuprestore.converters.PublicSettingsToJsonConverter;
import com.atlassian.confluence.impl.backuprestore.dao.BackupRestoreJobDao;
import com.atlassian.confluence.impl.backuprestore.domain.BackupRestoreJobSettingsRecord;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndependentBackupRestoreJobManager {
    private static final Logger log = LoggerFactory.getLogger(IndependentBackupRestoreJobManager.class);
    private final BackupRestoreJobDao backupRestoreJobDao;
    private final JsonToPublicSettingsConverter jsonToPublicSettingsConverter = new JsonToPublicSettingsConverter();
    private final PublicSettingsToJsonConverter publicSettingsToJsonConverter = new PublicSettingsToJsonConverter();

    public IndependentBackupRestoreJobManager(BackupRestoreJobDao backupRestoreJobDao) {
        this.backupRestoreJobDao = backupRestoreJobDao;
    }

    public BackupRestoreSettings getSettingsById(ExecutorService executorService, long jobId) {
        Future<BackupRestoreSettings> future = executorService.submit(() -> {
            BackupRestoreJobSettingsRecord settingsRecord = this.backupRestoreJobDao.getSettingsById(jobId);
            return this.jsonToPublicSettingsConverter.apply(settingsRecord.getSettings());
        });
        return this.unwrapFuture(future);
    }

    public BackupRestoreJob createAndSaveNewJob(ExecutorService executorService, JobOperation jobOperation, JobScope jobScope, JobState jobState, Instant createTime, String owner, BackupRestoreSettings backupRestoreSettings) {
        Future<BackupRestoreJob> future = executorService.submit(() -> {
            BackupRestoreJob job = new BackupRestoreJob();
            job.setJobOperation(jobOperation);
            job.setJobScope(jobScope);
            job.setCreateTime(createTime);
            job.setOwner(owner);
            job.setJobState(jobState);
            job.setFileName(backupRestoreSettings.getFileName());
            job.addSpaceKeys(backupRestoreSettings.getSpaceKeys());
            if (JobOperation.BACKUP.equals((Object)jobOperation)) {
                job.setFileExists(false);
            }
            this.backupRestoreJobDao.save(job);
            return job;
        });
        return this.unwrapFuture(future);
    }

    public BackupRestoreSettings createAndSaveNewJobSettingsRecord(ExecutorService executorService, long jobId, BackupRestoreSettings backupRestoreSettings) {
        Future<BackupRestoreSettings> future = executorService.submit(() -> {
            BackupRestoreJobSettingsRecord backupRestoreJobSettingsRecord = new BackupRestoreJobSettingsRecord(jobId, this.publicSettingsToJsonConverter.apply(backupRestoreSettings));
            this.backupRestoreJobDao.save(backupRestoreJobSettingsRecord);
            return backupRestoreSettings;
        });
        return this.unwrapFuture(future);
    }

    private <T> T unwrapFuture(Future<T> future) {
        try {
            return future.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public Optional<JobState> getJobState(ExecutorService executorService, long jobId) {
        Future<Optional> future = executorService.submit(() -> {
            BackupRestoreJob job = this.backupRestoreJobDao.getById(jobId);
            return Optional.ofNullable(job).map(BackupRestoreJob::getJobState);
        });
        return this.unwrapFuture(future);
    }

    public BackupRestoreJob updateJobStateAfterCompletion(long jobId, JobState probableNextJobState, Exception exception, Instant time, ExecutorService executorService) throws BackupRestoreException {
        JobState nextJobState = probableNextJobState;
        BackupRestoreJob job = this.backupRestoreJobDao.getById(jobId);
        if (probableNextJobState.equals((Object)JobState.FAILED)) {
            if (job.getJobState().equals((Object)JobState.CANCELLING)) {
                log.info("Backup restore job {} cancelled", (Object)job);
                nextJobState = JobState.CANCELLED;
            } else {
                String errorMessage = exception.getMessage();
                log.warn("Backup restore job {} failed: {}", new Object[]{job, errorMessage, exception});
                job.setErrorMessage(this.truncateMessage(errorMessage, 1000));
            }
        }
        job.setFinishProcessingTime(time);
        job.setJobState(nextJobState);
        try {
            this.updateJobStateInSeparateTransaction(job, executorService);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return job;
    }

    private void updateJobStateInSeparateTransaction(BackupRestoreJob job, ExecutorService executorService) throws BackupRestoreException, InterruptedException {
        try {
            executorService.submit(() -> this.backupRestoreJobDao.update(job)).get();
        }
        catch (ExecutionException e) {
            throw new BackupRestoreException(e);
        }
    }

    private String truncateMessage(String errorMessage, int maxLength) {
        if (errorMessage.length() <= maxLength) {
            return errorMessage;
        }
        return errorMessage.substring(0, maxLength - 3) + "...";
    }

    public List<BackupRestoreJob> findJobs(BackupRestoreJobsSearchFilter filter, ExecutorService executorService) {
        Future<List> future = executorService.submit(() -> this.backupRestoreJobDao.findJobs(filter));
        return this.unwrapFuture(future);
    }
}

