/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.backup.exporters;

import com.atlassian.confluence.backuprestore.exception.BackupRestoreException;
import com.atlassian.confluence.impl.backuprestore.backup.exporters.CommonDatabaseDataExporter;
import com.atlassian.confluence.impl.backuprestore.backup.exporters.Exporter;
import com.atlassian.confluence.impl.backuprestore.backup.exporters.Subscriber;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.spaces.Space;
import java.util.Collection;
import java.util.Collections;

public class PluginSettingDataExporter
implements Exporter,
Subscriber {
    private final CommonDatabaseDataExporter exporter;
    private final ExportableEntityInfo entityInfo;
    static final String SPACE_IDS = "spaceIds";
    static final String ENTITY_BY_CONTEXT_QUERY = "SELECT PLUGIN_SETTING.* FROM PLUGIN_SETTING JOIN SPACES ON SPACES.SPACEKEY = PLUGIN_SETTING.NAMESPACE WHERE SPACES.SPACEID IN  (:spaceIds)";

    public PluginSettingDataExporter(ExportableEntityInfo entityInfo, CommonDatabaseDataExporter exporter) {
        this.entityInfo = entityInfo;
        this.exporter = exporter;
    }

    @Override
    public ExportableEntityInfo getEntityInfo() {
        return this.entityInfo;
    }

    @Override
    public ExportableEntityInfo getEntityInfo(Class<?> exportedClass) {
        if (!this.entityInfo.getEntityClass().equals(exportedClass)) {
            throw new IllegalArgumentException("Unable to find entity info for class " + String.valueOf(exportedClass));
        }
        return this.entityInfo;
    }

    @Override
    public Collection<Class<?>> getWatchingEntityClasses() {
        return Collections.singleton(Space.class);
    }

    @Override
    public void onMonitoredObjectsExport(Class<?> exportedClass, Collection<Object> idList) throws InterruptedException, BackupRestoreException {
        if (!exportedClass.equals(Space.class)) {
            throw new IllegalArgumentException("PluginSetting exporter listens to Space objects only, but received events from unexpected class: " + String.valueOf(exportedClass));
        }
        this.exporter.exportUniqueInBatchByQueryWithInCondition(ENTITY_BY_CONTEXT_QUERY, SPACE_IDS, idList, "plugin settings export by space id");
    }
}

