/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.backup.exporters.converters;

import com.atlassian.confluence.impl.backuprestore.backup.exporters.converters.Converter;
import com.atlassian.confluence.impl.backuprestore.backup.exporters.converters.enrichment.ExportObjectsEnrichment;
import com.atlassian.confluence.impl.backuprestore.backup.models.DbRawObjectData;
import com.atlassian.confluence.impl.backuprestore.backup.models.EntityObjectReadyForExport;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import java.util.List;

public class DelegatingConverterWithEnrichment
implements Converter {
    private final Converter delegate;
    private final List<ExportObjectsEnrichment> enrichments;
    private final ExportableEntityInfo defaultEntityInfo;

    public DelegatingConverterWithEnrichment(Converter delegate, ExportableEntityInfo defaultEntityInfo, List<ExportObjectsEnrichment> enrichments) {
        this.delegate = delegate;
        this.enrichments = enrichments;
        this.defaultEntityInfo = defaultEntityInfo;
    }

    @Override
    public List<EntityObjectReadyForExport> convertToObjectsReadyForSerialisation(List<DbRawObjectData> dbObjectsProperties) {
        List<EntityObjectReadyForExport> results = this.delegate.convertToObjectsReadyForSerialisation(dbObjectsProperties);
        this.enrichments.forEach(enrichment -> enrichment.enrichElements(results));
        return results;
    }

    @Override
    public ExportableEntityInfo getEntityInfo() {
        return this.defaultEntityInfo;
    }

    @Override
    public ExportableEntityInfo getEntityInfo(Class<?> exportedClass) {
        return this.delegate.getEntityInfo(exportedClass);
    }
}

