/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.backup.exporters.converters;

import com.atlassian.confluence.impl.backuprestore.backup.exception.DataConversionException;
import com.atlassian.confluence.impl.backuprestore.backup.exporters.converters.AbstractDatabaseDataConverter;
import com.atlassian.confluence.impl.backuprestore.backup.models.DbRawObjectData;
import com.atlassian.confluence.impl.backuprestore.backup.models.EntityObjectReadyForExport;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateMetadataHelper;
import com.atlassian.confluence.impl.backuprestore.statistics.StatisticsCollector;
import com.atlassian.confluence.user.ConfluenceUserImpl;
import java.util.Collection;
import java.util.Map;

public class UserMappingDatabaseDataConverter
extends AbstractDatabaseDataConverter {
    public UserMappingDatabaseDataConverter(Collection<ExportableEntityInfo> entityInfos, HibernateMetadataHelper hibernateMetadataHelper, StatisticsCollector statisticsCollector) {
        super(entityInfos, hibernateMetadataHelper, statisticsCollector);
    }

    @Override
    protected Class<?> getHibernateEntityClass(Map<String, Object> objectProperties) throws DataConversionException {
        String entityType = (String)objectProperties.getOrDefault("entity_type", ConfluenceUserImpl.EntityType.USER.name());
        try {
            return this.getUserImplClassByEntityType(entityType);
        }
        catch (IllegalArgumentException e) {
            String message = String.format("Unexpected user type %s for ID %s", entityType, objectProperties.get("name"));
            throw new DataConversionException(message, e);
        }
    }

    @Override
    protected EntityObjectReadyForExport convertToObjectReadyForSerialisation(DbRawObjectData dbObject) throws DataConversionException {
        return this.convertToObjectReadyForSerialisationImpl(dbObject);
    }
}

