/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.backup.exporters.site;

import com.atlassian.confluence.impl.backuprestore.backup.exporters.DatabaseExporterHelper;
import com.atlassian.confluence.impl.backuprestore.backup.exporters.site.QueryProvider;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateMetadataHelper;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class DoubleColumnIdQueryProvider
implements QueryProvider {
    private final String initialSqlQuery;
    private final String repetitiveSqlQuery;
    private final List<String> idColumnNames;
    private final List<String> latestIdParamNames;
    private final String tableName;

    public DoubleColumnIdQueryProvider(DatabaseExporterHelper helper, ExportableEntityInfo entityInfo) {
        List<String> idColumnNamesRaw = entityInfo.getId().getColumnNames();
        if (idColumnNamesRaw.size() != 2) {
            throw new IllegalArgumentException("DoubleColumnIdQueryProvider requires exactly 2 id columns");
        }
        List<String> idColumnNamesWithoutQuotes = idColumnNamesRaw.stream().map(HibernateMetadataHelper::removeQuotes).toList();
        this.tableName = helper.checkNameDoesNotHaveSqlInjections(entityInfo.getTableName());
        this.idColumnNames = idColumnNamesWithoutQuotes;
        this.latestIdParamNames = idColumnNamesWithoutQuotes.stream().map(idColumnNameWithoutQuotes -> "latestMax" + StringUtils.capitalize((String)idColumnNameWithoutQuotes)).toList();
        this.initialSqlQuery = "SELECT * FROM " + this.tableName + " ORDER BY " + String.join((CharSequence)", ", idColumnNamesRaw);
        this.repetitiveSqlQuery = String.format("SELECT * FROM %s WHERE (%s = :%s and %s > :%s) OR (%s > :%s) ORDER BY %s", this.tableName, idColumnNamesRaw.get(0), this.latestIdParamNames.get(0), idColumnNamesRaw.get(1), this.latestIdParamNames.get(1), idColumnNamesRaw.get(0), this.latestIdParamNames.get(0), String.join((CharSequence)", ", idColumnNamesRaw));
    }

    @Override
    public String getInitialQuery() {
        return this.initialSqlQuery;
    }

    @Override
    public String getRepetitiveQuery() {
        return this.repetitiveSqlQuery;
    }

    @Override
    public List<String> getIdColumnNames() {
        return this.idColumnNames;
    }

    @Override
    public String getLatestIdParamName(int idIndex) {
        if (idIndex < 0 || idIndex >= this.latestIdParamNames.size()) {
            throw new IllegalArgumentException("Invalid id index for LatestIdParamName");
        }
        return this.latestIdParamNames.get(idIndex);
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }
}

