/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.hibernate;

import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.impl.backuprestore.hibernate.ArtificialHibernateEntity;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateField;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class AncestorsEntityInfo
implements ExportableEntityInfo {
    private final List<HibernateField> fields;

    public AncestorsEntityInfo(SessionFactoryImplementor sessionFactoryImplementor) {
        this.fields = new ArrayList<HibernateField>(Arrays.asList(this.createDescendentIdField(sessionFactoryImplementor), this.createAncestorIdField(sessionFactoryImplementor), this.createPositionField()));
    }

    private HibernateField createAncestorIdField(SessionFactoryImplementor sessionFactoryImplementor) {
        HibernateField.Type referenceToContentType = HibernateField.Type.manyToOne(sessionFactoryImplementor, ContentEntityObject.class);
        String[] columnNames = new String[]{"ANCESTORID"};
        return new HibernateField(referenceToContentType, "ancestorId", columnNames, ContentEntityObject.class, false);
    }

    private HibernateField createDescendentIdField(SessionFactoryImplementor sessionFactoryImplementor) {
        HibernateField.Type referenceToContentType = HibernateField.Type.manyToOne(sessionFactoryImplementor, ContentEntityObject.class);
        String[] columnNames = new String[]{"DESCENDENTID"};
        return new HibernateField(referenceToContentType, "descendentId", columnNames, ContentEntityObject.class, false);
    }

    private HibernateField createPositionField() {
        HibernateField.Type integerType = HibernateField.Type.wrap((Type)StandardBasicTypes.INTEGER);
        String[] columnNames = new String[]{"ANCESTORPOSITION"};
        return new HibernateField(integerType, "position", columnNames, null, false);
    }

    @Override
    public HibernateField getId() {
        return null;
    }

    @Override
    public String getDiscriminatorColumnName() {
        return null;
    }

    @Override
    public Object getDiscriminatorValue() {
        return null;
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator() {
        return null;
    }

    @Override
    public HibernateField.Type getHibernateTypeByFieldName(String propertyName) {
        throw new IllegalStateException("getHibernateTypeByFieldName must not be called for ancestor records because they must not present in XML file");
    }

    @Override
    public List<HibernateField> getFields() {
        return this.fields;
    }

    @Override
    public String getTableName() {
        return "CONFANCESTORS";
    }

    @Override
    public Class<?> getEntityClass() {
        return EntityClass.class;
    }

    public static class EntityClass
    implements ArtificialHibernateEntity {
    }
}

