/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.hibernate;

import com.atlassian.confluence.content.ContentProperty;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateField;
import com.atlassian.crowd.model.application.DirectoryMapping;
import com.atlassian.crowd.model.user.InternalUserCredentialRecord;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.persister.entity.AbstractEntityPersister;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.ManyToOneType;
import org.hibernate.type.OneToOneType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class DefaultExportableEntityInfo
implements ExportableEntityInfo {
    private final AbstractEntityPersister entityPersister;
    private final Class<?> entityClass;
    private final String tableName;
    private final HibernateField id;
    private final List<HibernateField> fields;
    private final Map<String, HibernateField.Type> hibernateTypeByPropertyNameMap;

    public DefaultExportableEntityInfo(AbstractEntityPersister entityPersister, SessionFactoryImplementor sessionFactory) {
        Type[] types;
        this.entityPersister = entityPersister;
        this.tableName = entityPersister.getTableName();
        this.entityClass = entityPersister.getEntityTuplizer().getMappedClass();
        String idPropertyName = entityPersister.getIdentifierPropertyName();
        LinkedList<String> idPropertyNames = new LinkedList<String>();
        LinkedList<HibernateField.Type> idTypes = new LinkedList<HibernateField.Type>();
        HashMap<String, Type> idColumnNameByType = new HashMap<String, Type>();
        if (idPropertyName == null) {
            String[] idNames = ((EmbeddedComponentType)entityPersister.getIdentifierType()).getPropertyNames();
            types = ((EmbeddedComponentType)entityPersister.getIdentifierType()).getSubtypes();
            idPropertyNames.addAll(Arrays.asList(idNames));
            List.of(types).forEach(type -> idTypes.add(HibernateField.Type.wrap(type)));
            for (int i = 0; i < types.length; ++i) {
                idColumnNameByType.put(idNames[i], types[i]);
            }
        } else {
            idColumnNameByType.put(idPropertyName, entityPersister.getIdentifierType());
            idPropertyNames.add(idPropertyName);
            idTypes.add(HibernateField.Type.wrap(entityPersister.getIdentifierType()));
        }
        Class<?> oneToOneReference = null;
        types = entityPersister.getPropertyTypes();
        String[] properties = entityPersister.getPropertyNames();
        ArrayList<HibernateField> fields = new ArrayList<HibernateField>();
        boolean[] propertyNullabilities = entityPersister.getPropertyNullability();
        for (int i = 0; i < types.length; ++i) {
            if (properties[i].equals("_identifierMapper")) continue;
            Type type2 = types[i];
            if (type2 instanceof OneToOneType) {
                oneToOneReference = this.getReferencedClass(type2);
                continue;
            }
            String[] columnNames = entityPersister.getPropertyColumnNames(i);
            HibernateField propertyInfo = new HibernateField(HibernateField.Type.wrap(type2), properties[i], columnNames, this.getReferencedClass(type2), propertyNullabilities[i]);
            fields.add(propertyInfo);
        }
        this.id = new HibernateField(idTypes, idPropertyNames, entityPersister.getKeyColumnNames(), oneToOneReference, false);
        if (this.entityClass.equals(ContentProperty.class)) {
            String[] contentColumn = new String[]{"CONTENTID"};
            HibernateField.Type manyType = HibernateField.Type.manyToOne(sessionFactory, ContentEntityObject.class);
            HibernateField contentField = new HibernateField(manyType, "content", contentColumn, ContentEntityObject.class, false);
            fields.add(contentField);
        }
        if (this.entityClass.equals(DirectoryMapping.class) || this.entityClass.equals(InternalUserCredentialRecord.class)) {
            String[] listIndexColumn = new String[]{"list_index"};
            HibernateField listIndexField = new HibernateField(HibernateField.Type.wrap((Type)StandardBasicTypes.INTEGER), "listIndex", listIndexColumn, null, true);
            fields.add(listIndexField);
        }
        this.fields = Collections.unmodifiableList(fields);
        this.hibernateTypeByPropertyNameMap = this.buildHibernateFieldByNameMap(idColumnNameByType, this.fields);
    }

    private Map<String, HibernateField.Type> buildHibernateFieldByNameMap(Map<String, Type> idColumnNameByType, List<HibernateField> fields) {
        HashMap<String, HibernateField.Type> map = new HashMap<String, HibernateField.Type>();
        idColumnNameByType.forEach((key, value) -> map.put((String)key, HibernateField.Type.wrap(value)));
        fields.forEach(field -> map.put(field.getPropertyName(), field.getType()));
        return map;
    }

    private Class<?> getReferencedClass(Type type) {
        if (type.getClass().equals(ManyToOneType.class) || type.getClass().equals(OneToOneType.class)) {
            EntityType entityType = (EntityType)type;
            String associatedEntityName = entityType.getAssociatedEntityName();
            try {
                return Class.forName(associatedEntityName);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException("Unable to find class for " + associatedEntityName + " provided by type " + String.valueOf(type), e);
            }
        }
        return null;
    }

    @Override
    public List<HibernateField> getFields() {
        return this.fields;
    }

    @Override
    public Class<?> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public HibernateField getId() {
        return this.id;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getDiscriminatorColumnName() {
        return this.entityPersister.getDiscriminatorColumnName();
    }

    @Override
    public Object getDiscriminatorValue() {
        return this.entityPersister.getDiscriminatorValue();
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator() {
        return this.entityPersister.getIdentifierGenerator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultExportableEntityInfo that = (DefaultExportableEntityInfo)o;
        return Objects.equals(this.entityClass, that.entityClass);
    }

    public int hashCode() {
        return Objects.hash(this.entityClass);
    }

    @Override
    public HibernateField.Type getHibernateTypeByFieldName(String propertyName) {
        return this.hibernateTypeByPropertyNameMap.get(propertyName);
    }
}

