/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.confluence.impl.backuprestore.hibernate;

import com.atlassian.confluence.impl.backuprestore.hibernate.ArtificialHibernateEntity;
import com.atlassian.confluence.impl.backuprestore.hibernate.ExportableEntityInfo;
import com.atlassian.confluence.impl.backuprestore.hibernate.HibernateField;
import com.atlassian.crowd.model.directory.DirectoryImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.id.IdentifierGenerator;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;

public class DirectoryAttributeEntityInfo
implements ExportableEntityInfo {
    private final List<HibernateField> fields;

    public DirectoryAttributeEntityInfo(SessionFactoryImplementor sessionFactoryImplementor) {
        this.fields = new ArrayList<HibernateField>(Arrays.asList(this.createDirectoryIdField(sessionFactoryImplementor), this.createAttributeNameField(), this.createAttributeValueField()));
    }

    private HibernateField createDirectoryIdField(SessionFactoryImplementor sessionFactoryImplementor) {
        HibernateField.Type referenceToDirectoryType = HibernateField.Type.manyToOne(sessionFactoryImplementor, DirectoryImpl.class);
        String[] columnNames = new String[]{"directory_id"};
        return new HibernateField(referenceToDirectoryType, "directoryId", columnNames, DirectoryImpl.class, false);
    }

    private HibernateField createAttributeNameField() {
        HibernateField.Type type = HibernateField.Type.wrap((Type)StandardBasicTypes.STRING);
        String[] columnNames = new String[]{"attribute_name"};
        return new HibernateField(Collections.singletonList(type), Collections.singletonList("attributeName"), columnNames, null, false);
    }

    private HibernateField createAttributeValueField() {
        HibernateField.Type type = HibernateField.Type.wrap((Type)StandardBasicTypes.STRING);
        String[] columnNames = new String[]{"attribute_value"};
        return new HibernateField(Collections.singletonList(type), Collections.singletonList("attributeValue"), columnNames, null, false);
    }

    @Override
    public HibernateField getId() {
        return null;
    }

    @Override
    public String getDiscriminatorColumnName() {
        return null;
    }

    @Override
    public Object getDiscriminatorValue() {
        return null;
    }

    @Override
    public IdentifierGenerator getIdentifierGenerator() {
        return null;
    }

    @Override
    public HibernateField.Type getHibernateTypeByFieldName(String propertyName) {
        throw new IllegalStateException("getHibernateTypeByFieldName must not be called for directory attribute records because they should not be present in entities.xml");
    }

    @Override
    public List<HibernateField> getFields() {
        return this.fields;
    }

    @Override
    public String getTableName() {
        return "cwd_directory_attribute";
    }

    @Override
    public Class<?> getEntityClass() {
        return EntityClass.class;
    }

    public static class EntityClass
    implements ArtificialHibernateEntity {
    }
}

